/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocElement;
import helma.doc.DocResourceElement;
import helma.doc.Util;
import helma.framework.repository.Resource;
import helma.util.StringUtils;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Token;

public class DocFunction
extends DocResourceElement {
    private int startLine;

    protected DocFunction(String name, Resource res, DocElement parent, int type, int lineno) {
        super(name, res, type);
        this.parent = parent;
        this.startLine = lineno;
    }

    public static DocFunction newAction(Resource res) throws IOException {
        return DocFunction.newAction(res, null);
    }

    public static DocFunction newAction(Resource res, DocElement parent) throws IOException {
        String name = res.getBaseName();
        String[] lines = StringUtils.splitLines(res.getContent());
        DocFunction func = new DocFunction(name, res, parent, 2, 1);
        String rawComment = "";
        Token[] tokens = DocFunction.parseTokens(res);
        rawComment = Util.extractString(lines, DocFunction.getPoint(tokens[0]), DocFunction.getPoint(tokens[1]));
        rawComment = Util.chopComment(rawComment);
        func.parseComment(rawComment);
        func.content = res.getContent();
        return func;
    }

    public static DocFunction[] newFunctions(Resource res) throws IOException {
        return DocFunction.newFunctions(res, null);
    }

    public static DocFunction[] newFunctions(Resource res, DocElement parent) throws IOException {
        String[] lines = StringUtils.splitLines(res.getContent());
        Token[] tokens = DocFunction.parseTokens(res);
        ArrayList list = new ArrayList();
        DocFunction.scanFunctions(lines, tokens, list, res, parent, 0, tokens.length);
        return list.toArray(new DocFunction[0]);
    }

    private static void scanFunctions(String[] lines, Token[] tokens, List list, Resource res, DocElement parent, int start, int end) {
        Token lastToken = new Token(124, "", 0, 0);
        String lastNameString = null;
        String functionName = null;
        String context = null;
        String comment = "";
        for (int i = start; i < end - 1; ++i) {
            Point marker = DocFunction.getPoint(lastToken);
            Token token = tokens[i];
            boolean dropFunction = false;
            if (token.type == 1) {
                String c = Util.extractString(lines, marker, DocFunction.getPoint(token));
                if (c.startsWith("/**")) {
                    comment = c;
                }
            } else if (token.type == 81) {
                context = token.string;
            } else if (token.type == 82 && context != null) {
                context = null;
            } else if (token.type == 42) {
                if (parent instanceof DocFunction) {
                    lastNameString = parent.getName() + ".prototype";
                }
            } else if (token.type == 38) {
                if (lastToken.type != 104) {
                    lastNameString = token.string;
                    marker = DocFunction.getPoint(token);
                    marker.x -= token.string.length() + 1;
                } else {
                    lastNameString = lastNameString + "." + token.string;
                }
            } else if (token.type == 105) {
                int level;
                Point p = DocFunction.getPoint(token);
                Token peekToken = tokens[i + 1];
                if (peekToken.type == 38) {
                    marker = p;
                    marker.x -= 9;
                    token = tokens[++i];
                    functionName = token.string;
                } else {
                    functionName = context != null ? context + "." + lastNameString : lastNameString;
                }
                DocFunction theFunction = null;
                if (!dropFunction) {
                    DocElement par = parent instanceof DocFunction ? parent.parent : parent;
                    theFunction = DocFunction.newFunction(functionName, res, par, token.lineno + 1);
                    theFunction.parseComment(comment);
                    list.add(theFunction);
                }
                comment = "";
                while (i < end && token.type != 84) {
                    token = tokens[++i];
                    if (token.type != 38 || theFunction.type != 4) continue;
                    theFunction.addParameter(token.string);
                }
                token = tokens[++i];
                int j = i + 1;
                int n = level = token.type == 81 ? 1 : 0;
                while (i < end && level > 0) {
                    try {
                        token = tokens[++i];
                    }
                    catch (Exception anything) {
                        continue;
                    }
                    if (token.type == 81) {
                        ++level;
                        continue;
                    }
                    if (token.type != 82) continue;
                    --level;
                }
                if (dropFunction) continue;
                DocFunction.scanFunctions(lines, tokens, list, res, theFunction, j, i);
                marker.x = 0;
                theFunction.content = Util.extractString(lines, marker, DocFunction.getPoint(token));
            }
            lastToken = token;
        }
    }

    private static DocFunction newFunction(String funcName, Resource res, DocElement parent, int lineno) {
        if (funcName.endsWith("_action")) {
            return new DocFunction(funcName, res, parent, 2, lineno);
        }
        if (funcName.endsWith("_macro")) {
            return new DocFunction(funcName, res, parent, 5, lineno);
        }
        return new DocFunction(funcName, res, parent, 4, lineno);
    }

    protected static Token[] parseTokens(Resource res) throws IOException {
        InputStreamReader reader = new InputStreamReader(res.getInputStream());
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(Context.getCurrentContext());
        compilerEnv.setGenerateDebugInfo(true);
        compilerEnv.setGeneratingSource(true);
        compilerEnv.setOptimizationLevel(-1);
        ErrorReporter errorReporter = Context.getCurrentContext().getErrorReporter();
        Parser parser = new Parser(compilerEnv, errorReporter);
        return parser.parseTokens((Reader)reader, res.getName(), 0);
    }

    protected static Point getPoint(Token token) {
        return new Point(token.offset, token.lineno);
    }

    public String getPrototype() {
        return "docfunction";
    }

    public int getStartLine() {
        return this.startLine;
    }
}

