/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocApplication;
import helma.doc.DocException;
import helma.doc.DocTag;
import helma.doc.Util;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class DocElement {
    public static final int APPLICATION = 0;
    public static final int PROTOTYPE = 1;
    public static final int ACTION = 2;
    public static final int TEMPLATE = 3;
    public static final int FUNCTION = 4;
    public static final int MACRO = 5;
    public static final int SKIN = 6;
    public static final int PROPERTIES = 7;
    public static final String[] typeNames = new String[]{"Application", "Prototype", "Action", "Template", "Function", "Macro", "Skin", "Properties"};
    String name;
    int type;
    DocElement parent = null;
    Map children = new HashMap();
    String content = "";
    String comment = "";
    List tags = new Vector();
    List parameters = new Vector();

    protected DocElement(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return typeNames[this.type];
    }

    public String getComment() {
        return this.comment;
    }

    public String getContent() {
        return this.content;
    }

    public void addTag(String rawContent) {
        if (this.tags == null) {
            this.tags = new Vector();
        }
        try {
            DocTag tag = DocTag.parse(rawContent);
            this.tags.add(tag);
        }
        catch (DocException doc) {
            DocElement.debug(doc.toString());
        }
    }

    public DocTag[] listTags() {
        return this.tags.toArray(new DocTag[0]);
    }

    public DocTag[] listTags(String type) {
        Vector retval = new Vector();
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!((DocTag)this.tags.get(i)).getType().equals(type)) continue;
            retval.add(this.tags.get(i));
        }
        return (DocTag[])retval.toArray();
    }

    public boolean hasParameter(String param) {
        return this.parameters.contains(param);
    }

    public String[] listParameters() {
        return this.parameters.toArray(new String[0]);
    }

    protected void addParameter(String param) {
        this.parameters.add(param);
    }

    void parseComment(String rawComment) {
        try {
            rawComment = rawComment.trim();
            StringTokenizer tok = new StringTokenizer(rawComment, "\n", true);
            int BLANK = 0;
            int TEXT = 1;
            int TAGS = 2;
            boolean lastEmpty = false;
            int mode = BLANK;
            StringBuffer buf = new StringBuffer();
            while (tok.hasMoreTokens()) {
                String line = Util.chopDelimiters(tok.nextToken().trim());
                if ("".equals(line)) {
                    lastEmpty = mode != BLANK;
                    continue;
                }
                int n = mode = mode == BLANK ? TEXT : mode;
                if (DocTag.isTagStart(line)) {
                    if (mode == TEXT) {
                        this.comment = buf.toString();
                    }
                    if (mode == TAGS) {
                        this.addTag(buf.toString());
                    }
                    buf = new StringBuffer();
                    mode = TAGS;
                }
                if (lastEmpty) {
                    buf.append("\n");
                }
                buf.append(line);
                buf.append(" ");
                lastEmpty = false;
            }
            if (mode == TEXT) {
                this.comment = buf.toString().trim();
            } else if (mode == TAGS) {
                this.addTag(buf.toString());
            }
        }
        catch (RuntimeException rt) {
            DocElement.debug("parse error in " + this.name + ": " + rt.getMessage());
        }
    }

    public void setParent(DocElement parent) {
        this.parent = parent;
    }

    public void addChild(DocElement child) {
        if (child == null) {
            return;
        }
        this.children.put(child.getElementName(), child);
    }

    public int countChildren() {
        return this.children.size();
    }

    public Map getChildren() {
        return this.children;
    }

    public DocElement[] listChildren() {
        Object[] keys = this.children.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        DocElement[] arr = new DocElement[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            arr[i] = (DocElement)this.children.get(keys[i]);
        }
        return arr;
    }

    public DocApplication getDocApplication() {
        for (DocElement el = this; el != null; el = (DocElement)el.getParentElement()) {
            if (!(el instanceof DocApplication)) continue;
            return (DocApplication)el;
        }
        return null;
    }

    public String getElementName() {
        return typeNames[this.type].toLowerCase() + "_" + this.name;
    }

    public DocElement getChildElement(String name) {
        try {
            return (DocElement)this.children.get(name);
        }
        catch (ClassCastException cce) {
            DocElement.debug(cce.toString());
            cce.printStackTrace();
            return null;
        }
    }

    public Object getParentElement() {
        return this.parent;
    }

    public String getPrototype() {
        return "doc" + typeNames[this.type].toLowerCase();
    }

    public String toString() {
        return "[" + typeNames[this.type] + " " + this.name + "]";
    }

    public static void debug(String msg) {
        System.out.println(msg);
    }
}

