/*
 * Decompiled with CFR 0.152.
 */
package helma.doc;

import helma.doc.DocComparator;
import helma.doc.DocElement;
import helma.doc.DocPrototype;
import helma.framework.core.Application;
import helma.framework.core.Prototype;
import helma.main.Server;
import helma.util.ResourceProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class DocApplication
extends DocElement {
    Application app;
    HashSet excluded;

    public DocApplication(Application app) {
        super(app.getName(), 0);
        this.app = app;
        this.readProps();
    }

    private void readProps() {
        ResourceProperties appProps = this.app.getProperties();
        this.excluded = new HashSet();
        this.addExclude("cvs");
        this.addExclude(".docs");
        String excludeProps = appProps.getProperty("helma.excludeDocs");
        if (excludeProps != null) {
            StringTokenizer tok = new StringTokenizer(excludeProps, ",");
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken().trim();
                this.addExclude(str);
            }
        }
    }

    public void addExclude(String str) {
        this.excluded.add(str.toLowerCase());
    }

    public boolean isExcluded(String name) {
        return this.excluded.contains(name.toLowerCase());
    }

    public void readApplication() throws IOException {
        this.readProps();
        this.children.clear();
        Iterator it = this.app.getPrototypes().iterator();
        while (it.hasNext()) {
            Prototype proto = (Prototype)it.next();
            proto.checkForUpdates();
            DocPrototype pt = new DocPrototype(proto, this);
            this.addChild(pt);
            pt.readFiles();
            Iterator i = this.children.values().iterator();
            while (i.hasNext()) {
                ((DocPrototype)i.next()).checkInheritance();
            }
        }
    }

    public DocElement[] listFunctions() {
        Vector allFunctions = new Vector();
        Iterator i = this.children.values().iterator();
        while (i.hasNext()) {
            DocElement proto = (DocElement)i.next();
            allFunctions.addAll(proto.children.values());
        }
        Collections.sort(allFunctions, new DocComparator(1, this));
        return allFunctions.toArray(new DocElement[allFunctions.size()]);
    }

    public String getElementName() {
        return "api";
    }

    public Object getParentElement() {
        Server s = Server.getServer();
        return s.getApplication(this.name);
    }
}

