/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.event.generator;

import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.bsf.util.event.generator.AdapterClassLoader;
import org.apache.bsf.util.event.generator.ByteUtility;
import org.apache.bsf.util.event.generator.Bytecode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventAdapterGenerator {
    public static AdapterClassLoader ldr = new AdapterClassLoader();
    static Class EVENTLISTENER = null;
    static String CLASSPACKAGE = "org/apache/bsf/util/event/adapters/";
    static String WRITEDIRECTORY = null;
    static byte[] CLASSHEADER;
    static short BASECPCOUNT;
    static byte[] BASECP;
    static byte[] FIXEDCLASSBYTES;
    static byte[] INITMETHOD;
    private static Log logger;

    public static Class makeEventAdapterClass(Class listenerType, boolean writeClassFile) {
        logger.info((Object)"EventAdapterGenerator");
        if (EVENTLISTENER.isAssignableFrom(listenerType)) {
            int i;
            String adapterClassName;
            boolean exceptionable = false;
            boolean nonExceptionable = false;
            byte[] constantPool = null;
            int cpCount = 0;
            String listenerTypeName = listenerType.getName();
            logger.info((Object)("ListenerTypeName: " + listenerTypeName));
            String finalAdapterClassName = adapterClassName = CLASSPACKAGE + (listenerTypeName.endsWith("Listener") ? listenerTypeName.substring(0, listenerTypeName.length() - 8) : listenerTypeName).replace('.', '_') + "Adapter";
            Class cached = null;
            int suffixIndex = 0;
            do {
                if (null == (cached = ldr.getLoadedClass(finalAdapterClassName))) continue;
                logger.info((Object)("cached:  " + cached));
                try {
                    if (listenerType.isAssignableFrom(cached)) {
                        return cached;
                    }
                    finalAdapterClassName = adapterClassName + "_" + suffixIndex++;
                }
                catch (VerifyError ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                    return cached;
                }
            } while (cached != null);
            String eventListenerName = listenerTypeName.replace('.', '/');
            Method[] lms = listenerType.getMethods();
            cpCount = (short)(cpCount + 4);
            constantPool = Bytecode.addUtf8(constantPool, eventListenerName);
            constantPool = Bytecode.addUtf8(constantPool, finalAdapterClassName);
            constantPool = Bytecode.addClass(constantPool, (short)17);
            constantPool = Bytecode.addClass(constantPool, (short)18);
            for (i = 0; i < lms.length; ++i) {
                Class<?>[] exceptionTypes = lms[i].getExceptionTypes();
                if (0 < exceptionTypes.length) {
                    exceptionable = true;
                    continue;
                }
                nonExceptionable = true;
            }
            int nonExceptionableCount = 0;
            if (nonExceptionable) {
                nonExceptionableCount = 3;
                cpCount = (short)(cpCount + nonExceptionableCount);
                constantPool = Bytecode.addUtf8(constantPool, "processEvent");
                constantPool = Bytecode.addNameAndType(constantPool, (short)21, (short)8);
                constantPool = Bytecode.addInterfaceMethodRef(constantPool, (short)12, (short)22);
            }
            int exceptionableCount = 0;
            if (exceptionable) {
                int classIndex = BASECPCOUNT + cpCount + 1;
                int nameIndex = BASECPCOUNT + cpCount + 0;
                int natIndex = BASECPCOUNT + cpCount + 3;
                exceptionableCount = 5;
                cpCount = (short)(cpCount + exceptionableCount);
                constantPool = Bytecode.addUtf8(constantPool, "processExceptionableEvent");
                constantPool = Bytecode.addUtf8(constantPool, "java/lang/Exception");
                constantPool = Bytecode.addClass(constantPool, (short)classIndex);
                constantPool = Bytecode.addNameAndType(constantPool, (short)nameIndex, (short)8);
                constantPool = Bytecode.addInterfaceMethodRef(constantPool, (short)12, (short)natIndex);
            }
            short cpBaseIndex = (short)(BASECPCOUNT + cpCount);
            logger.debug((Object)("cpBaseIndex: " + cpBaseIndex));
            for (i = 0; i < lms.length; ++i) {
                String eventMethodName = lms[i].getName();
                String eventName = lms[i].getParameterTypes()[0].getName().replace('.', '/');
                cpCount = (short)(cpCount + 3);
                constantPool = Bytecode.addUtf8(constantPool, eventMethodName);
                constantPool = Bytecode.addUtf8(constantPool, "(L" + eventName + ";)V");
                constantPool = Bytecode.addString(constantPool, (short)(BASECPCOUNT + cpCount - 3));
            }
            boolean[] propertyChangeFlag = new boolean[lms.length];
            int cpIndexPCE = 0;
            for (int i2 = 0; i2 < lms.length; ++i2) {
                String eventName = lms[i2].getParameterTypes()[0].getName().replace('.', '/');
                if (eventName.equalsIgnoreCase("java/beans/PropertyChangeEvent")) {
                    propertyChangeFlag[i2] = true;
                    if (false != cpIndexPCE) continue;
                    constantPool = Bytecode.addUtf8(constantPool, eventName);
                    constantPool = Bytecode.addUtf8(constantPool, "getPropertyName");
                    constantPool = Bytecode.addUtf8(constantPool, "()Ljava/lang/String;");
                    constantPool = Bytecode.addClass(constantPool, (short)(BASECPCOUNT + cpCount));
                    constantPool = Bytecode.addNameAndType(constantPool, (short)(BASECPCOUNT + cpCount + 1), (short)(BASECPCOUNT + cpCount + 2));
                    constantPool = Bytecode.addMethodRef(constantPool, (short)(BASECPCOUNT + cpCount + 3), (short)(BASECPCOUNT + cpCount + 4));
                    cpCount = (short)(cpCount + 6);
                    cpIndexPCE = BASECPCOUNT + cpCount - 1;
                    continue;
                }
                propertyChangeFlag[i2] = false;
            }
            short cpExceptionBaseIndex = (short)(BASECPCOUNT + cpCount);
            logger.debug((Object)("cpExceptionBaseIndex: " + cpExceptionBaseIndex));
            int[][] excpIndex = new int[lms.length][];
            for (int i3 = 0; i3 < lms.length; ++i3) {
                Class<?>[] exceptionTypes = lms[i3].getExceptionTypes();
                excpIndex[i3] = new int[exceptionTypes.length];
                for (int j = 0; j < exceptionTypes.length; ++j) {
                    constantPool = Bytecode.addUtf8(constantPool, exceptionTypes[j].getName().replace('.', '/'));
                    constantPool = Bytecode.addClass(constantPool, (short)(BASECPCOUNT + cpCount));
                    excpIndex[i3][j] = BASECPCOUNT + cpCount + 1;
                    cpCount = (short)(cpCount + 2);
                }
            }
            byte[] newClass = CLASSHEADER;
            short count = (short)(BASECPCOUNT + cpCount);
            newClass = ByteUtility.addBytes(newClass, count);
            newClass = ByteUtility.addBytes(newClass, BASECP);
            newClass = ByteUtility.addBytes(newClass, constantPool);
            newClass = ByteUtility.addBytes(newClass, FIXEDCLASSBYTES);
            newClass = ByteUtility.addBytes(newClass, (short)(lms.length + 1));
            newClass = ByteUtility.addBytes(newClass, INITMETHOD);
            for (int i4 = 0; i4 < lms.length; ++i4) {
                newClass = ByteUtility.addBytes(newClass, (short)1);
                newClass = ByteUtility.addBytes(newClass, (short)(cpBaseIndex + 3 * i4 + 0));
                newClass = ByteUtility.addBytes(newClass, (short)(cpBaseIndex + 3 * i4 + 1));
                newClass = ByteUtility.addBytes(newClass, (short)1);
                newClass = ByteUtility.addBytes(newClass, (short)3);
                int length = 32;
                if (0 < excpIndex[i4].length) {
                    length += 5 + 8 * (1 + excpIndex[i4].length);
                }
                if (propertyChangeFlag[i4]) {
                    length += 2;
                }
                newClass = ByteUtility.addBytes(newClass, (long)length);
                newClass = ByteUtility.addBytes(newClass, (short)6);
                newClass = ByteUtility.addBytes(newClass, (short)3);
                length = 20;
                if (exceptionable && 0 < excpIndex[i4].length) {
                    length += 5;
                }
                if (propertyChangeFlag[i4]) {
                    length += 2;
                }
                newClass = ByteUtility.addBytes(newClass, (long)length);
                newClass = ByteUtility.addBytes(newClass, (byte)42);
                newClass = ByteUtility.addBytes(newClass, (byte)-76);
                newClass = ByteUtility.addBytes(newClass, (short)15);
                if (propertyChangeFlag[i4]) {
                    newClass = ByteUtility.addBytes(newClass, (byte)43);
                    newClass = ByteUtility.addBytes(newClass, (byte)-74);
                    newClass = ByteUtility.addBytes(newClass, (short)cpIndexPCE);
                } else {
                    newClass = ByteUtility.addBytes(newClass, (byte)18);
                    newClass = ByteUtility.addBytes(newClass, (byte)(cpBaseIndex + 3 * i4 + 2));
                }
                newClass = ByteUtility.addBytes(newClass, (byte)4);
                newClass = ByteUtility.addBytes(newClass, (byte)-67);
                newClass = ByteUtility.addBytes(newClass, (short)10);
                newClass = ByteUtility.addBytes(newClass, (byte)89);
                newClass = ByteUtility.addBytes(newClass, (byte)3);
                newClass = ByteUtility.addBytes(newClass, (byte)43);
                newClass = ByteUtility.addBytes(newClass, (byte)83);
                newClass = ByteUtility.addBytes(newClass, (byte)-71);
                length = 23;
                if (exceptionable && nonExceptionable) {
                    if (0 < lms[i4].getExceptionTypes().length) {
                        length += 5;
                    }
                } else if (exceptionable) {
                    length += 2;
                }
                newClass = ByteUtility.addBytes(newClass, (short)length);
                newClass = ByteUtility.addBytes(newClass, (byte)3);
                newClass = ByteUtility.addBytes(newClass, (byte)0);
                newClass = ByteUtility.addBytes(newClass, (byte)-79);
                if (exceptionable && 0 < excpIndex[i4].length) {
                    newClass = ByteUtility.addBytes(newClass, (byte)77);
                    newClass = ByteUtility.addBytes(newClass, (byte)44);
                    newClass = ByteUtility.addBytes(newClass, (byte)-65);
                    newClass = ByteUtility.addBytes(newClass, (byte)87);
                    newClass = ByteUtility.addBytes(newClass, (byte)-79);
                    length = excpIndex[i4].length;
                    newClass = ByteUtility.addBytes(newClass, (short)(1 + length));
                    for (int j = 0; j < length; ++j) {
                        newClass = ByteUtility.addBytes(newClass, (short)0);
                        if (propertyChangeFlag[i4]) {
                            newClass = ByteUtility.addBytes(newClass, (short)21);
                            newClass = ByteUtility.addBytes(newClass, (short)22);
                        } else {
                            newClass = ByteUtility.addBytes(newClass, (short)19);
                            newClass = ByteUtility.addBytes(newClass, (short)20);
                        }
                        newClass = ByteUtility.addBytes(newClass, (short)excpIndex[i4][j]);
                    }
                    newClass = ByteUtility.addBytes(newClass, (short)0);
                    if (propertyChangeFlag[i4]) {
                        newClass = ByteUtility.addBytes(newClass, (short)21);
                        newClass = ByteUtility.addBytes(newClass, (short)25);
                    } else {
                        newClass = ByteUtility.addBytes(newClass, (short)19);
                        newClass = ByteUtility.addBytes(newClass, (short)23);
                    }
                    newClass = nonExceptionable ? ByteUtility.addBytes(newClass, (short)26) : ByteUtility.addBytes(newClass, (short)23);
                } else {
                    newClass = ByteUtility.addBytes(newClass, (short)0);
                }
                newClass = ByteUtility.addBytes(newClass, (short)0);
            }
            newClass = ByteUtility.addBytes(newClass, (short)0);
            logger.debug((Object)("adapterName: " + finalAdapterClassName));
            logger.debug((Object)("cpCount: " + count + " = " + BASECPCOUNT + " + " + cpCount));
            logger.debug((Object)("methodCount: " + (lms.length + 1)));
            if (writeClassFile) {
                try {
                    FileOutputStream fos = new FileOutputStream(finalAdapterClassName + ".class");
                    fos.write(newClass);
                    fos.close();
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
                try {
                    Class<?> ret = ldr.loadClass(finalAdapterClassName);
                    logger.debug((Object)("EventAdapterGenerator: " + ret.getName() + " dynamically generated"));
                    return ret;
                }
                catch (ClassNotFoundException ex) {
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
            try {
                Class ret = ldr.defineClass(finalAdapterClassName, newClass);
                logger.debug((Object)("EventAdapterGenerator: " + ret.getName() + " dynamically generated"));
                return ret;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return null;
    }

    static {
        logger = LogFactory.getLog((String)EventAdapterGenerator.class.getName());
        String USERCLASSPACKAGE = System.getProperty("DynamicEventClassPackage", "");
        if (!USERCLASSPACKAGE.equals("")) {
            CLASSPACKAGE = USERCLASSPACKAGE;
        }
        if (CLASSPACKAGE.length() > 0 && !(CLASSPACKAGE = CLASSPACKAGE.replace('\\', '/')).endsWith("/")) {
            CLASSPACKAGE = CLASSPACKAGE + "/";
        }
        if ((WRITEDIRECTORY = System.getProperty("DynamicEventClassWriteDirectory", CLASSPACKAGE)).length() > 0 && !(WRITEDIRECTORY = WRITEDIRECTORY.replace('\\', '/')).endsWith("/")) {
            WRITEDIRECTORY = WRITEDIRECTORY + "/";
        }
        try {
            EVENTLISTENER = Thread.currentThread().getContextClassLoader().loadClass("java.util.EventListener");
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-54);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-2);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-70);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (byte)-66);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (short)3);
        CLASSHEADER = ByteUtility.addBytes(CLASSHEADER, (short)45);
        BASECPCOUNT = (short)17;
        BASECP = Bytecode.addUtf8(BASECP, "()V");
        BASECP = Bytecode.addUtf8(BASECP, "<init>");
        BASECP = Bytecode.addUtf8(BASECP, "Code");
        BASECP = Bytecode.addUtf8(BASECP, "eventProcessor");
        BASECP = Bytecode.addUtf8(BASECP, "java/lang/Object");
        BASECP = Bytecode.addUtf8(BASECP, "org/apache/bsf/util/event/EventAdapterImpl");
        BASECP = Bytecode.addUtf8(BASECP, "org/apache/bsf/util/event/EventProcessor");
        BASECP = Bytecode.addUtf8(BASECP, "(Ljava/lang/String;[Ljava/lang/Object;)V");
        BASECP = Bytecode.addUtf8(BASECP, "Lorg/apache/bsf/util/event/EventProcessor;");
        BASECP = Bytecode.addClass(BASECP, (short)5);
        BASECP = Bytecode.addClass(BASECP, (short)6);
        BASECP = Bytecode.addClass(BASECP, (short)7);
        BASECP = Bytecode.addNameAndType(BASECP, (short)2, (short)1);
        BASECP = Bytecode.addNameAndType(BASECP, (short)4, (short)9);
        BASECP = Bytecode.addFieldRef(BASECP, (short)11, (short)14);
        BASECP = Bytecode.addMethodRef(BASECP, (short)11, (short)13);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)33);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)20);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)11);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)1);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)19);
        FIXEDCLASSBYTES = ByteUtility.addBytes(FIXEDCLASSBYTES, (short)0);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)2);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)3);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, 17L);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)1);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, 5L);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (byte)42);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (byte)-73);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)16);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (byte)-79);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)0);
        INITMETHOD = ByteUtility.addBytes(INITMETHOD, (short)0);
    }
}

