/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.util.CodeBuffer;
import org.apache.bsf.util.ObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BSFManager {
    protected static String version = "205.20060327";
    protected static Hashtable registeredEngines = new Hashtable();
    protected static Hashtable extn2Lang = new Hashtable();
    protected Hashtable loadedEngines = new Hashtable();
    protected ObjectRegistry objectRegistry = new ObjectRegistry();
    protected PropertyChangeSupport pcs;
    protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    protected String tempDir = ".";
    protected String classPath;
    protected Vector declaredBeans = new Vector();
    private Log logger = LogFactory.getLog((String)this.getClass().getName());

    public BSFManager() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public static String getVersion() {
        return version;
    }

    public Object apply(String lang, String source, int lineNo, int columnNo, Object funcBody, Vector paramNames, Vector arguments) throws BSFException {
        this.logger.debug((Object)"BSFManager:apply");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object funcBodyf = funcBody;
        final Vector paramNamesf = paramNames;
        final Vector argumentsf = arguments;
        Object result = null;
        try {
            Object resultf = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return e.apply(sourcef, lineNof, columnNof, funcBodyf, paramNamesf, argumentsf);
                }
            });
            result = resultf;
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception: ", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
        return result;
    }

    public void compileApply(String lang, String source, int lineNo, int columnNo, Object funcBody, Vector paramNames, Vector arguments, CodeBuffer cb) throws BSFException {
        this.logger.debug((Object)"BSFManager:compileApply");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object funcBodyf = funcBody;
        final Vector paramNamesf = paramNames;
        final Vector argumentsf = arguments;
        final CodeBuffer cbf = cb;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    e.compileApply(sourcef, lineNof, columnNof, funcBodyf, paramNamesf, argumentsf, cbf);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception :", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
    }

    public void compileExpr(String lang, String source, int lineNo, int columnNo, Object expr, CodeBuffer cb) throws BSFException {
        this.logger.debug((Object)"BSFManager:compileExpr");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object exprf = expr;
        final CodeBuffer cbf = cb;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    e.compileExpr(sourcef, lineNof, columnNof, exprf, cbf);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception :", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
    }

    public void compileScript(String lang, String source, int lineNo, int columnNo, Object script, CodeBuffer cb) throws BSFException {
        this.logger.debug((Object)"BSFManager:compileScript");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object scriptf = script;
        final CodeBuffer cbf = cb;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    e.compileScript(sourcef, lineNof, columnNof, scriptf, cbf);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception :", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
    }

    public void declareBean(String beanName, Object bean, Class type) throws BSFException {
        this.logger.debug((Object)"BSFManager:declareBean");
        this.registerBean(beanName, bean);
        BSFDeclaredBean tempBean = new BSFDeclaredBean(beanName, bean, type);
        this.declaredBeans.addElement(tempBean);
        Enumeration enginesEnum = this.loadedEngines.elements();
        while (enginesEnum.hasMoreElements()) {
            BSFEngine engine = (BSFEngine)enginesEnum.nextElement();
            engine.declareBean(tempBean);
        }
    }

    public Object eval(String lang, String source, int lineNo, int columnNo, Object expr) throws BSFException {
        this.logger.debug((Object)"BSFManager:eval");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object exprf = expr;
        Object result = null;
        try {
            Object resultf = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return e.eval(sourcef, lineNof, columnNof, exprf);
                }
            });
            result = resultf;
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception: ", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
        return result;
    }

    public void exec(String lang, String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.logger.debug((Object)"BSFManager:exec");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object scriptf = script;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    e.exec(sourcef, lineNof, columnNof, scriptf);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception :", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
    }

    public void iexec(String lang, String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.logger.debug((Object)"BSFManager:iexec");
        final BSFEngine e = this.loadScriptingEngine(lang);
        final String sourcef = source;
        final int lineNof = lineNo;
        final int columnNof = columnNo;
        final Object scriptf = script;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    e.iexec(sourcef, lineNof, columnNof, scriptf);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception :", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
    }

    public ClassLoader getClassLoader() {
        this.logger.debug((Object)"BSFManager:getClassLoader");
        return this.classLoader;
    }

    public String getClassPath() {
        this.logger.debug((Object)"BSFManager:getClassPath");
        if (this.classPath == null) {
            try {
                this.classPath = System.getProperty("java.class.path");
            }
            catch (Throwable t) {
                this.logger.debug((Object)"Exception :", t);
            }
        }
        return this.classPath;
    }

    public static String getLangFromFilename(String fileName) throws BSFException {
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex != -1) {
            String extn = fileName.substring(dotIndex + 1);
            String langval = (String)extn2Lang.get(extn);
            String lang = null;
            int loops = 0;
            if (langval != null) {
                int index;
                while ((index = langval.indexOf(":", 0)) != -1) {
                    lang = langval.substring(0, index);
                    langval = langval.substring(index + 1);
                    ++loops;
                    try {
                        String engineName = (String)registeredEngines.get(lang);
                        Class.forName(engineName);
                        break;
                    }
                    catch (ClassNotFoundException cnfe) {
                        lang = langval;
                    }
                }
                if (loops == 0) {
                    lang = langval;
                }
            }
            if (lang != null && lang != "") {
                return lang;
            }
        }
        throw new BSFException(500, "file extension missing or unknown: unable to determine language for '" + fileName + "'");
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public static boolean isLanguageRegistered(String lang) {
        return registeredEngines.get(lang) != null;
    }

    public BSFEngine loadScriptingEngine(String lang) throws BSFException {
        this.logger.debug((Object)"BSFManager:loadScriptingEngine");
        BSFEngine eng = (BSFEngine)this.loadedEngines.get(lang);
        if (eng != null) {
            return eng;
        }
        String engineClassName = (String)registeredEngines.get(lang);
        if (engineClassName == null) {
            this.logger.error((Object)("unsupported language: " + lang));
            throw new BSFException(20, "unsupported language: " + lang);
        }
        try {
            Class<?> engineClass = this.classLoader == null ? Class.forName(engineClassName) : this.classLoader.loadClass(engineClassName);
            final BSFEngine engf = (BSFEngine)engineClass.newInstance();
            final BSFManager thisf = this;
            final String langf = lang;
            final Vector dbf = this.declaredBeans;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    engf.initialize(thisf, langf, dbf);
                    return null;
                }
            });
            eng = engf;
            this.loadedEngines.put(lang, eng);
            this.pcs.addPropertyChangeListener(eng);
            return eng;
        }
        catch (PrivilegedActionException prive) {
            this.logger.error((Object)"Exception :", (Throwable)prive);
            throw (BSFException)prive.getException();
        }
        catch (Throwable t) {
            this.logger.error((Object)"Exception :", t);
            throw new BSFException(500, "unable to load language: " + lang, t);
        }
    }

    public Object lookupBean(String beanName) {
        this.logger.debug((Object)"BSFManager:lookupBean");
        try {
            return ((BSFDeclaredBean)this.objectRegistry.lookup((String)beanName)).bean;
        }
        catch (IllegalArgumentException e) {
            this.logger.debug((Object)"Exception :", (Throwable)e);
            return null;
        }
    }

    public void registerBean(String beanName, Object bean) {
        this.logger.debug((Object)"BSFManager:registerBean");
        BSFDeclaredBean tempBean = bean == null ? new BSFDeclaredBean(beanName, null, null) : new BSFDeclaredBean(beanName, bean, bean.getClass());
        this.objectRegistry.register(beanName, tempBean);
    }

    public static void registerScriptingEngine(String lang, String engineClassName, String[] extensions) {
        registeredEngines.put(lang, engineClassName);
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                String langstr = (String)extn2Lang.get(extensions[i]);
                langstr = langstr == null ? lang : lang + ":" + langstr;
                extn2Lang.put(extensions[i], langstr);
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.logger.debug((Object)"BSFManager:setClassLoader");
        this.pcs.firePropertyChange("classLoader", this.classLoader, classLoader);
        this.classLoader = classLoader;
    }

    public void setClassPath(String classPath) {
        this.logger.debug((Object)"BSFManager:setClassPath");
        this.pcs.firePropertyChange("classPath", this.classPath, classPath);
        this.classPath = classPath;
    }

    public void setObjectRegistry(ObjectRegistry objectRegistry) {
        this.logger.debug((Object)"BSFManager:setObjectRegistry");
        this.objectRegistry = objectRegistry;
    }

    public void setTempDir(String tempDir) {
        this.logger.debug((Object)"BSFManager:setTempDir");
        this.pcs.firePropertyChange("tempDir", this.tempDir, tempDir);
        this.tempDir = tempDir;
    }

    public void terminate() {
        this.logger.debug((Object)"BSFManager:terminate");
        Enumeration enginesEnum = this.loadedEngines.elements();
        while (enginesEnum.hasMoreElements()) {
            BSFEngine engine = (BSFEngine)enginesEnum.nextElement();
            engine.terminate();
        }
        this.loadedEngines = new Hashtable();
    }

    public void undeclareBean(String beanName) throws BSFException {
        this.logger.debug((Object)"BSFManager:undeclareBean");
        this.unregisterBean(beanName);
        BSFDeclaredBean tempBean = null;
        boolean found = false;
        Iterator i = this.declaredBeans.iterator();
        while (i.hasNext()) {
            tempBean = (BSFDeclaredBean)i.next();
            if (!tempBean.name.equals(beanName)) continue;
            found = true;
            break;
        }
        if (found) {
            this.declaredBeans.removeElement(tempBean);
            Enumeration enginesEnum = this.loadedEngines.elements();
            while (enginesEnum.hasMoreElements()) {
                BSFEngine engine = (BSFEngine)enginesEnum.nextElement();
                engine.undeclareBean(tempBean);
            }
        }
    }

    public void unregisterBean(String beanName) {
        this.logger.debug((Object)"BSFManager:unregisterBean");
        this.objectRegistry.unregister(beanName);
    }

    static {
        try {
            Enumeration<URL> e = BSFManager.class.getClassLoader().getResources("org/apache/bsf/Languages.properties");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                InputStream is = url.openStream();
                Properties p = new Properties();
                p.load(is);
                Enumeration<?> keys = p.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = p.getProperty(key);
                    String className = value.substring(0, value.indexOf(","));
                    String exts = value.substring(value.indexOf(",") + 1, value.length());
                    StringTokenizer st = new StringTokenizer(exts, "|");
                    String[] extensions = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        extensions[i] = st.nextToken().trim();
                        ++i;
                    }
                    BSFManager.registerScriptingEngine(key, className, extensions);
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Error reading Languages file " + ex);
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
            System.err.println("Syntax error in Languages resource bundle");
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
            System.err.println("Initialization error: " + mre.toString());
        }
    }
}

