/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportConnection;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public class TransportManager {
    private static final Logger log;
    String hostname;
    int port;
    Socket sock;
    Object connectionSemaphore = new Object();
    boolean flagKexOngoing = false;
    boolean connectionClosed = false;
    Throwable reasonClosedCause = null;
    Vector kexBlockedSendQueue = new Vector(10);
    TransportConnection tc;
    KexManager km;
    Vector messageHandlers = new Vector();
    Thread receiveThread;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.ssh2.transport.TransportManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public TransportManager(String host, int port) throws IOException {
        this.hostname = host;
        this.port = port;
        try {
            this.sock = new Socket(host, port);
        }
        catch (IOException e) {
            throw (IOException)new IOException("Cannot establish TCP connection to " + host + ":" + port).initCause(e);
        }
        this.tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream());
    }

    public ConnectionInfo getConnectionInfo(int kexNumber) throws IOException {
        return this.km.getOrWaitForConnectionInfo(kexNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable cause) {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                return;
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connectionClosed = true;
            this.reasonClosedCause = cause;
            this.connectionSemaphore.notifyAll();
        }
    }

    public void initialize(CryptoWishList cwl, ServerHostKeyVerifier verifier, DHGexParameters dhgex) throws IOException {
        ClientServerHello csh = new ClientServerHello(this.sock.getInputStream(), this.sock.getOutputStream());
        this.km = new KexManager(this, csh, cwl, this.hostname, this.port, verifier);
        this.km.initiateKEX(cwl, dhgex);
        this.receiveThread = new Thread(new Runnable(){

            public void run() {
                block9: {
                    try {
                        TransportManager.this.receiveLoop();
                    }
                    catch (IOException e) {
                        TransportManager.this.close(e);
                        if (!log.isEnabled()) break block9;
                        log.log(50, "Receive thread: error in receiveLoop: " + e.getMessage());
                    }
                }
                if (log.isEnabled()) {
                    log.log(50, "Receive thread: back from receiveLoop");
                }
                if (TransportManager.this.km != null) {
                    try {
                        TransportManager.this.km.handleMessage(null, 0);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                int i = 0;
                while (i < TransportManager.this.messageHandlers.size()) {
                    HandlerEntry he = (HandlerEntry)TransportManager.this.messageHandlers.elementAt(i);
                    try {
                        he.mh.handleMessage(null, 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        });
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler mh, int low, int high) {
        HandlerEntry he = new HandlerEntry();
        he.mh = mh;
        he.low = low;
        he.high = high;
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            this.messageHandlers.addElement(he);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler mh, int low, int high) {
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            int i = 0;
            while (i < this.messageHandlers.size()) {
                HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (he.mh == mh && he.low == low && he.high == high) {
                    this.messageHandlers.removeElementAt(i);
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] msg) throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(msg);
            }
            catch (IOException e) {
                this.close(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() throws IOException {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            int i = 0;
            while (i < this.kexBlockedSendQueue.size()) {
                this.tc.sendMessage((byte[])this.kexBlockedSendQueue.elementAt(i));
                ++i;
            }
            this.connectionSemaphore.notifyAll();
        }
    }

    public void forceKeyExchange(CryptoWishList cwl, DHGexParameters dhgex) throws IOException {
        this.km.initiateKEX(cwl, dhgex);
    }

    public void changeRecvCipher(BlockCipher bc, MAC mac) {
        this.tc.changeRecvCipher(bc, mac);
    }

    public void changeSendCipher(BlockCipher bc, MAC mac) {
        this.tc.changeSendCipher(bc, mac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(byte[] msg) throws IOException {
        var2_2 = this.connectionSemaphore;
        synchronized (var2_2) {
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
                }
                if (!this.flagKexOngoing) {
                    try {
                        this.tc.sendMessage(msg);
                        ** break;
                    }
                    catch (IOException e) {
                        this.close(e);
                        throw e;
                    }
                }
                if (Thread.currentThread() == this.receiveThread) {
                    this.kexBlockedSendQueue.addElement(msg);
                    return;
                }
                try {
                    this.connectionSemaphore.wait();
                }
                catch (InterruptedException var3_3) {
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
lbl23:
            // 1 sources

            return;
        }
    }

    public void receiveLoop() throws IOException {
        byte[] msg = new byte[35000];
        while (true) {
            int msglen = this.tc.receiveMessage(msg, 0, msg.length);
            int type = msg[0] & 0xFF;
            if (type == 2 || type == 4) continue;
            if (type == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (type == 1) {
                TypesReader tr = new TypesReader(msg, 0, msglen);
                tr.readByte();
                int reason_code = tr.readUINT32();
                StringBuffer reasonBuffer = new StringBuffer();
                reasonBuffer.append(tr.readString("UTF-8"));
                if (reasonBuffer.length() > 255) {
                    reasonBuffer.setLength(255);
                    reasonBuffer.setCharAt(254, '.');
                    reasonBuffer.setCharAt(253, '.');
                    reasonBuffer.setCharAt(252, '.');
                }
                int i = 0;
                while (i < reasonBuffer.length()) {
                    char c = reasonBuffer.charAt(i);
                    if (c < ' ' || c > '~') {
                        reasonBuffer.setCharAt(i, '\ufffd');
                    }
                    ++i;
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + reason_code + "): " + reasonBuffer.toString());
            }
            if (type == 20 || type == 21 || type >= 30 && type <= 49) {
                this.km.handleMessage(msg, msglen);
                continue;
            }
            MessageHandler mh = null;
            int i = 0;
            while (i < this.messageHandlers.size()) {
                HandlerEntry he = (HandlerEntry)this.messageHandlers.elementAt(i);
                if (he.low <= type && type <= he.high) {
                    mh = he.mh;
                    break;
                }
                ++i;
            }
            if (mh == null) {
                throw new IOException("Unexpected SSH message (type " + type + ")");
            }
            mh.handleMessage(msg, msglen);
        }
    }

    class HandlerEntry {
        MessageHandler mh;
        int low;
        int high;

        HandlerEntry() {
        }
    }
}

