/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.signature;

import ch.ethz.ssh2.crypto.SimpleDERReader;
import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASignature;
import java.io.IOException;
import java.math.BigInteger;

public class RSASHA1Verify {
    private static final Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.ssh2.signature.RSASHA1Verify");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public static RSAPublicKey decodeSSHRSAPublicKey(byte[] key) throws IOException {
        TypesReader tr = new TypesReader(key);
        String key_format = tr.readString();
        if (!key_format.equals("ssh-rsa")) {
            throw new IllegalArgumentException("This is not a ssh-rsa public key");
        }
        BigInteger e = tr.readMPINT();
        BigInteger n = tr.readMPINT();
        if (tr.remain() != 0) {
            throw new IOException("Padding in RSA public key!");
        }
        return new RSAPublicKey(e, n);
    }

    public static byte[] encodeSSHRSAPublicKey(RSAPublicKey pk) throws IOException {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-rsa");
        tw.writeMPInt(pk.getE());
        tw.writeMPInt(pk.getN());
        return tw.getBytes();
    }

    public static RSASignature decodeSSHRSASignature(byte[] sig) throws IOException {
        TypesReader tr = new TypesReader(sig);
        String sig_format = tr.readString();
        if (!sig_format.equals("ssh-rsa")) {
            throw new IOException("Peer sent wrong signature format");
        }
        byte[] s = tr.readByteString();
        if (s.length == 0) {
            throw new IOException("Error in RSA signature, S is empty.");
        }
        if (log.isEnabled()) {
            log.log(80, "Decoding ssh-rsa signature string (length: " + s.length + ")");
        }
        if (tr.remain() != 0) {
            throw new IOException("Padding in RSA signature!");
        }
        return new RSASignature(new BigInteger(1, s));
    }

    public static byte[] encodeSSHRSASignature(RSASignature sig) throws IOException {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-rsa");
        byte[] s = sig.getS().toByteArray();
        if (s.length > 1 && s[0] == 0) {
            tw.writeString(s, 1, s.length - 1);
        } else {
            tw.writeString(s, 0, s.length);
        }
        return tw.getBytes();
    }

    public static RSASignature generateSignature(byte[] message, RSAPrivateKey pk) throws IOException {
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        byte[] byArray = new byte[15];
        byArray[0] = 48;
        byArray[1] = 33;
        byArray[2] = 48;
        byArray[3] = 9;
        byArray[4] = 6;
        byArray[5] = 5;
        byArray[6] = 43;
        byArray[7] = 14;
        byArray[8] = 3;
        byArray[9] = 2;
        byArray[10] = 26;
        byArray[11] = 5;
        byArray[13] = 4;
        byArray[14] = 20;
        byte[] der_header = byArray;
        int rsa_block_len = (pk.getN().bitLength() + 7) / 8;
        int num_pad = rsa_block_len - (2 + der_header.length + sha_message.length) - 1;
        if (num_pad < 8) {
            throw new IOException("Cannot sign with RSA, message too long");
        }
        byte[] sig = new byte[der_header.length + sha_message.length + 2 + num_pad];
        sig[0] = 1;
        int i = 0;
        while (i < num_pad) {
            sig[i + 1] = -1;
            ++i;
        }
        sig[num_pad + 1] = 0;
        System.arraycopy(der_header, 0, sig, 2 + num_pad, der_header.length);
        System.arraycopy(sha_message, 0, sig, 2 + num_pad + der_header.length, sha_message.length);
        BigInteger m = new BigInteger(1, sig);
        BigInteger s = m.modPow(pk.getD(), pk.getN());
        return new RSASignature(s);
    }

    public static boolean verifySignature(byte[] message, RSASignature ds, RSAPublicKey dpk) throws IOException {
        SHA1 md = new SHA1();
        md.update(message);
        byte[] sha_message = new byte[md.getDigestLength()];
        md.digest(sha_message);
        BigInteger n = dpk.getN();
        BigInteger e = dpk.getE();
        BigInteger s = ds.getS();
        if (n.compareTo(s) <= 0) {
            log.log(20, "ssh-rsa signature: n.compareTo(s) <= 0");
            return false;
        }
        int rsa_block_len = (n.bitLength() + 7) / 8;
        if (rsa_block_len < 1) {
            log.log(20, "ssh-rsa signature: rsa_block_len < 1");
            return false;
        }
        byte[] v = s.modPow(e, n).toByteArray();
        int startpos = 0;
        if (v.length > 0 && v[0] == 0) {
            ++startpos;
        }
        if (v.length - startpos != rsa_block_len - 1) {
            log.log(20, "ssh-rsa signature: (v.length - startpos) != (rsa_block_len - 1)");
            return false;
        }
        if (v[startpos] != 1) {
            log.log(20, "ssh-rsa signature: v[startpos] != 0x01");
            return false;
        }
        int pos = startpos + 1;
        while (true) {
            if (pos >= v.length) {
                log.log(20, "ssh-rsa signature: pos >= v.length");
                return false;
            }
            if (v[pos] == 0) break;
            if (v[pos] != -1) {
                log.log(20, "ssh-rsa signature: v[pos] != (byte) 0xff");
                return false;
            }
            ++pos;
        }
        int num_pad = pos - (startpos + 1);
        if (num_pad < 8) {
            log.log(20, "ssh-rsa signature: num_pad < 8");
            return false;
        }
        if (++pos >= v.length) {
            log.log(20, "ssh-rsa signature: pos >= v.length");
            return false;
        }
        SimpleDERReader dr = new SimpleDERReader(v, pos, v.length - pos);
        byte[] seq = dr.readSequenceAsByteArray();
        if (dr.available() != 0) {
            log.log(20, "ssh-rsa signature: dr.available() != 0");
            return false;
        }
        dr.resetInput(seq);
        byte[] digestAlgorithm = dr.readSequenceAsByteArray();
        if (digestAlgorithm.length < 8 || digestAlgorithm.length > 9) {
            log.log(20, "ssh-rsa signature: (digestAlgorithm.length < 8) || (digestAlgorithm.length > 9)");
            return false;
        }
        byte[] byArray = new byte[9];
        byArray[0] = 6;
        byArray[1] = 5;
        byArray[2] = 43;
        byArray[3] = 14;
        byArray[4] = 3;
        byArray[5] = 2;
        byArray[6] = 26;
        byArray[7] = 5;
        byte[] digestAlgorithm_sha1 = byArray;
        int i = 0;
        while (i < digestAlgorithm.length) {
            if (digestAlgorithm[i] != digestAlgorithm_sha1[i]) {
                log.log(20, "ssh-rsa signature: digestAlgorithm[i] != digestAlgorithm_sha1[i]");
                return false;
            }
            ++i;
        }
        byte[] digest = dr.readOctetString();
        if (dr.available() != 0) {
            log.log(20, "ssh-rsa signature: dr.available() != 0 II");
            return false;
        }
        if (digest.length != sha_message.length) {
            log.log(20, "ssh-rsa signature: digest.length != sha_message.length");
            return false;
        }
        int i2 = 0;
        while (i2 < sha_message.length) {
            if (sha_message[i2] != digest[i2]) {
                log.log(20, "ssh-rsa signature: sha_message[i] != digest[i]");
                return false;
            }
            ++i2;
        }
        return true;
    }
}

