/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelInputStream;
import ch.ethz.ssh2.channel.ChannelOutputStream;
import ch.ethz.ssh2.channel.LocalAcceptThread;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketChannelOpenConfirmation;
import ch.ethz.ssh2.packets.PacketOpenDirectTCPIPChannel;
import ch.ethz.ssh2.packets.PacketOpenSessionChannel;
import ch.ethz.ssh2.packets.PacketSessionExecCommand;
import ch.ethz.ssh2.packets.PacketSessionPtyRequest;
import ch.ethz.ssh2.packets.PacketSessionStartShell;
import ch.ethz.ssh2.packets.PacketSessionSubsystemRequest;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.util.Vector;

public class ChannelManager
implements MessageHandler {
    private static final Logger log;
    private TransportManager tm;
    private int nextLocalChannel = 100;
    private Vector channels = new Vector();
    private Vector listenerThreads = new Vector();
    private boolean listenerThreadsAllowed = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.ssh2.channel.ChannelManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public ChannelManager(TransportManager tm) {
        this.tm = tm;
        tm.registerMessageHandler(this, 90, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(int id) {
        Vector vector = this.channels;
        synchronized (vector) {
            int i = 0;
            while (i < this.channels.size()) {
                Channel c = (Channel)this.channels.elementAt(i);
                if (c.localID == id) {
                    return c;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(int id) {
        Vector vector = this.channels;
        synchronized (vector) {
            int i = 0;
            while (i < this.channels.size()) {
                Channel c = (Channel)this.channels.elementAt(i);
                if (c.localID == id) {
                    this.channels.removeElementAt(i);
                    break;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChannel(Channel c) {
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.addElement(c);
            return this.nextLocalChannel++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeChannel(Channel c, String reason) throws IOException {
        if (log.isEnabled()) {
            log.log(50, "closeChannel (" + c.remoteID + ")");
        }
        Object object = c;
        synchronized (object) {
            if (c.state != 4 && c.state != 5) {
                c.state = 4;
                c.reasonClosed = reason;
            }
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            if (log.isEnabled()) {
                log.log(50, "Sending SSH_MSG_CHANNEL_CLOSE (" + c.remoteID + ")");
            }
            byte[] msg = new byte[]{97, (byte)(c.remoteID >> 24), (byte)(c.remoteID >> 16), (byte)(c.remoteID >> 8), (byte)c.remoteID};
            this.tm.sendMessage(msg);
            c.closeMessageSent = true;
        }
        object = c;
        synchronized (object) {
            while (true) {
                if (c.closeMessageRecv) {
                    this.removeChannel(c.localID);
                    return;
                }
                try {
                    c.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEOF(Channel c) throws IOException {
        Object object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            byte[] msg = new byte[]{96, (byte)(c.remoteID >> 24), (byte)(c.remoteID >> 16), (byte)(c.remoteID >> 8), (byte)c.remoteID};
            if (!c.closeMessageSent) {
                this.tm.sendMessage(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendData(Channel c, byte[] buffer, int pos, int len) throws IOException {
        while (len > 0) {
            thislen = 0;
            var6_6 = c;
            synchronized (var6_6) {
                block17: {
                    block16: {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            if (c.state != 2 && c.state != 4 && c.state != 5) {
                                throw new IOException("SSH channel in strange state. (" + c.state + ")");
                            }
                            if (c.state == 4 || c.state == 5) {
                                throw new IOException("SSH channel is closed. (" + c.reasonClosed + ")");
                            }
                            if (c.remoteWindow > 0) {
                                if (c.remoteWindow >= len) {
                                    ** break;
                                }
                                break block16;
                            }
                            try {
                                c.wait();
                            }
                            catch (InterruptedException var7_8) {
                                continue;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
lbl21:
                        // 1 sources

                        v0 = len;
                        break block17;
                    }
                    v0 = thislen = c.remoteWindow;
                }
                if (thislen > c.estimatedMaxDataLen) {
                    thislen = c.estimatedMaxDataLen;
                }
                c.remoteWindow -= thislen;
            }
            var6_6 = c.channelSendLock;
            synchronized (var6_6) {
                if (c.closeMessageSent) {
                    throw new IOException("SSH channel is closed. (" + c.reasonClosed + ")");
                }
                msg = new byte[9 + thislen];
                msg[0] = 94;
                msg[1] = (byte)(c.remoteID >> 24);
                msg[2] = (byte)(c.remoteID >> 16);
                msg[3] = (byte)(c.remoteID >> 8);
                msg[4] = (byte)c.remoteID;
                msg[5] = (byte)(thislen >> 24);
                msg[6] = (byte)(thislen >> 16);
                msg[7] = (byte)(thislen >> 8);
                msg[8] = (byte)thislen;
                System.arraycopy(buffer, pos, msg, 9, thislen);
                this.tm.sendMessage(msg);
            }
            pos += thislen;
            len -= thislen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(LocalAcceptThread thr) throws IOException {
        Vector vector = this.listenerThreads;
        synchronized (vector) {
            if (!this.listenerThreadsAllowed) {
                throw new IOException("Too late, this connection is closed.");
            }
            this.listenerThreads.addElement(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Channel createDirectTCPIPChannel(String host_to_connect, int port_to_connect, String originator_IP_address, int originator_port) throws IOException {
        Channel c = new Channel();
        c.cm = this;
        c.localWindow = 30000;
        c.localMaxPacketSize = 33976;
        c.state = 1;
        c.stdinStream = new ChannelOutputStream(c);
        c.stdoutStream = new ChannelInputStream(c, false);
        c.stderrStream = new ChannelInputStream(c, true);
        c.localID = this.addChannel(c);
        PacketOpenDirectTCPIPChannel dtc = new PacketOpenDirectTCPIPChannel(c.localID, c.localWindow, c.localMaxPacketSize, host_to_connect, port_to_connect, originator_IP_address, originator_port);
        this.tm.sendMessage(dtc.getPayload());
        Channel channel = c;
        synchronized (channel) {
            String detail;
            while (true) {
                if (c.state != 1) {
                    if (c.state == 2) return c;
                    this.removeChannel(c.localID);
                    if (c.state != 4) break;
                    detail = c.reasonClosed;
                    throw new IOException("Could not open session channel (" + detail + ")");
                }
                try {
                    c.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            detail = "state: " + c.state;
            throw new IOException("Could not open session channel (" + detail + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Channel createSessionChannel() throws IOException {
        Channel c = new Channel();
        c.cm = this;
        c.localWindow = 30000;
        c.localMaxPacketSize = 33976;
        c.state = 1;
        c.stdinStream = new ChannelOutputStream(c);
        c.stdoutStream = new ChannelInputStream(c, false);
        c.stderrStream = new ChannelInputStream(c, true);
        c.localID = this.addChannel(c);
        PacketOpenSessionChannel smo = new PacketOpenSessionChannel(c.localID, c.localWindow, c.localMaxPacketSize);
        this.tm.sendMessage(smo.getPayload());
        Channel channel = c;
        synchronized (channel) {
            String detail;
            while (true) {
                if (c.state != 1) {
                    if (c.state == 2) return c;
                    this.removeChannel(c.localID);
                    if (c.state != 4) break;
                    detail = c.reasonClosed;
                    throw new IOException("Could not open session channel (" + detail + ")");
                }
                try {
                    c.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            detail = "state: " + c.state;
            throw new IOException("Could not open session channel (" + detail + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPTY(Channel c, String term, int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels, byte[] terminal_modes) throws IOException {
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request PTY on this channel (" + c.reasonClosed + ")");
            }
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request PTY on this channel (" + c.reasonClosed + ")");
            }
            PacketSessionPtyRequest spr = new PacketSessionPtyRequest(c.remoteID, true, term, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels, terminal_modes);
            this.tm.sendMessage(spr.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSubSystem(Channel c, String subSystemName) throws IOException {
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request subsystem on this channel (" + c.reasonClosed + ")");
            }
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request subsystem on this channel (" + c.reasonClosed + ")");
            }
            PacketSessionSubsystemRequest ssr = new PacketSessionSubsystemRequest(c.remoteID, true, subSystemName);
            this.tm.sendMessage(ssr.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execCommand(Channel c, String cmd) throws IOException {
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot execute command on this channel (" + c.reasonClosed + ")");
            }
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot execute command on this channel (" + c.reasonClosed + ")");
            }
            PacketSessionExecCommand sm = new PacketSessionExecCommand(c.remoteID, true, cmd);
            this.tm.sendMessage(sm.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startShell(Channel c) throws IOException {
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot start shell on this channel (" + c.reasonClosed + ")");
            }
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot start shell on this channel (" + c.reasonClosed + ")");
            }
            PacketSessionStartShell sm = new PacketSessionStartShell(c.remoteID, true);
            this.tm.sendMessage(sm.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelExtendedData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int dataType = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        int len = (msg[9] & 0xFF) << 24 | (msg[10] & 0xFF) << 16 | (msg[11] & 0xFF) << 8 | msg[12] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EXTENDED_DATA message for non-existent channel " + id);
        }
        if (dataType != 1) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has unknown type (" + dataType + ")");
        }
        if (len != msglen - 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong len (calculated " + (msglen - 13) + ", got " + len + ")");
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_EXTENDED_DATA (" + id + ", " + len + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 2) {
                return;
            }
            if (c.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c.localWindow -= len;
            System.arraycopy(msg, 13, c.stderrBuffer, c.stderrWritepos, len);
            c.stderrWritepos += len;
            c.notifyAll();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int waitUntilDataAvailable(Channel c, long timeout) {
        long end_time = 0L;
        boolean end_time_set = false;
        Channel channel = c;
        synchronized (channel) {
            block5: while (true) {
                while (true) {
                    int stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                    int stderrAvail = c.stderrWritepos - c.stderrReadpos;
                    if (stdoutAvail > 0 || stderrAvail > 0) {
                        return 1;
                    }
                    if (c.state != 2) {
                        return 0;
                    }
                    if (c.stdoutEOF && c.stderrEOF) {
                        return 0;
                    }
                    if (timeout > 0L) {
                        if (!end_time_set) {
                            end_time = System.currentTimeMillis() + timeout;
                            end_time_set = true;
                        } else {
                            timeout = end_time - System.currentTimeMillis();
                            if (timeout <= 0L) {
                                return -1;
                            }
                        }
                    }
                    try {
                        if (timeout > 0L) {
                            c.wait(timeout);
                            continue block5;
                        }
                        c.wait();
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable(Channel c, boolean extended) throws IOException {
        Channel channel = c;
        synchronized (channel) {
            if (c.state == 5) {
                throw new IOException("This SSH2 channel has failed.");
            }
            if (extended) {
                int avail = c.stderrWritepos - c.stderrReadpos;
                int n = avail > 0 ? avail : (c.stderrEOF ? -1 : 0);
                return n;
            }
            int avail = c.stdoutWritepos - c.stdoutReadpos;
            int n = avail > 0 ? avail : (c.stdoutEOF ? -1 : 0);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChannelData(Channel c, boolean extended, byte[] target, int off, int len) throws IOException {
        int copylen = 0;
        int increment = 0;
        Object object = c;
        synchronized (object) {
            if (c.state == 5) {
                throw new IOException("This SSH2 channel has failed.");
            }
            if (c.state != 2 && log.isEnabled()) {
                log.log(80, "getChannelData: NOTICE: channel is not in STATE_OPEN");
            }
            int stdoutAvail = 0;
            int stderrAvail = 0;
            while (true) {
                stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                stderrAvail = c.stderrWritepos - c.stderrReadpos;
                if (!extended && stdoutAvail != 0 || extended && stderrAvail != 0) break;
                if (c.state != 2) {
                    if (log.isEnabled()) {
                        log.log(80, "getChannelData: channel is not in STATE_OPEN");
                    }
                    return -1;
                }
                if (!extended && c.stdoutEOF || extended && c.stderrEOF) {
                    return -1;
                }
                try {
                    c.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!extended) {
                copylen = stdoutAvail > len ? len : stdoutAvail;
                System.arraycopy(c.stdoutBuffer, c.stdoutReadpos, target, off, copylen);
                c.stdoutReadpos += copylen;
                if (c.stdoutReadpos != c.stdoutWritepos) {
                    System.arraycopy(c.stdoutBuffer, c.stdoutReadpos, c.stdoutBuffer, 0, c.stdoutWritepos - c.stdoutReadpos);
                }
                c.stdoutWritepos -= c.stdoutReadpos;
                c.stdoutReadpos = 0;
            } else {
                copylen = stderrAvail > len ? len : stderrAvail;
                System.arraycopy(c.stderrBuffer, c.stderrReadpos, target, off, copylen);
                c.stderrReadpos += copylen;
                if (c.stderrReadpos != c.stderrWritepos) {
                    System.arraycopy(c.stderrBuffer, c.stderrReadpos, c.stderrBuffer, 0, c.stderrWritepos - c.stderrReadpos);
                }
                c.stderrWritepos -= c.stderrReadpos;
                c.stderrReadpos = 0;
            }
            if (c.state != 2) {
                return copylen;
            }
            if (c.localWindow < 15000) {
                int minFreeSpace = Math.min(30000 - c.stdoutWritepos, 30000 - c.stderrWritepos);
                increment = minFreeSpace - c.localWindow;
                c.localWindow = minFreeSpace;
            }
        }
        if (increment > 0) {
            object = c.channelSendLock;
            synchronized (object) {
                byte[] msg = c.msgWindowAdjust;
                msg[0] = 93;
                msg[1] = (byte)(c.remoteID >> 24);
                msg[2] = (byte)(c.remoteID >> 16);
                msg[3] = (byte)(c.remoteID >> 8);
                msg[4] = (byte)c.remoteID;
                msg[5] = (byte)(increment >> 24);
                msg[6] = (byte)(increment >> 16);
                msg[7] = (byte)(increment >> 8);
                msg[8] = (byte)increment;
                if (!c.closeMessageSent) {
                    this.tm.sendMessage(msg);
                }
            }
            if (log.isEnabled()) {
                log.log(50, "Sent SSH_MSG_CHANNEL_WINDOW_ADJUST (" + c.remoteID + ", " + increment + ")");
            }
        }
        return copylen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int len = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_DATA message for non-existent channel " + id);
        }
        if (len != msglen - 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong len (calculated " + (msglen - 9) + ", got " + len + ")");
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_DATA (" + id + ", " + len + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 2) {
                return;
            }
            if (c.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c.localWindow -= len;
            System.arraycopy(msg, 9, c.stdoutBuffer, c.stdoutWritepos, len);
            c.stdoutWritepos += len;
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelWindowAdjust(byte[] msg, int msglen) throws IOException {
        if (msglen != 9) {
            throw new IOException("SSH_MSG_CHANNEL_WINDOW_ADJUST message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int windowChange = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected WindowAdjust message for non-existent Channel " + id);
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_WINDOW_ADJUST (" + id + ", " + windowChange + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 2) {
                return;
            }
            c.remoteWindow += windowChange;
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_REQUEST message for non-existent channel " + id);
        }
        String type = tr.readString("US-ASCII");
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_REQUEST (" + id + ", '" + type + "')");
        }
        if (type.equals("exit-status")) {
            if (tr.readBoolean()) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            int exit_status = tr.readUINT32();
            Channel channel = c;
            synchronized (channel) {
                c.exit_status = new Integer(exit_status);
                c.notifyAll();
            }
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            if (log.isEnabled()) {
                log.log(50, "Got EXIT STATUS (" + id + " => status " + exit_status + ")");
            }
            return;
        }
        if (type.equals("exit-signal")) {
            if (tr.readBoolean()) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            String signame = tr.readString("US-ASCII");
            Channel channel = c;
            synchronized (channel) {
                c.exit_signal = signame;
                c.notifyAll();
            }
            tr.readBoolean();
            tr.readString();
            tr.readString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            if (log.isEnabled()) {
                log.log(50, "Got EXIT SIGNAL (" + id + " => signal " + signame + ")");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelEOF(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_EOF message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EOF message for non-existent channel " + id);
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_EOF (" + id + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            c.stdoutEOF = true;
            c.stderrEOF = true;
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelClose(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_CLOSE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_CLOSE message for non-existent channel " + id);
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_CLOSE (" + id + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            c.stdoutEOF = true;
            c.stderrEOF = true;
            if (c.state != 4) {
                c.state = 4;
                c.reasonClosed = "Close requested by remote";
            }
            c.closeMessageRecv = true;
            c.notifyAll();
        }
    }

    public void msgChannelSuccess(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_SUCCESS message has wrong size (" + msglen + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelFailure(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_FAILURE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_FAILURE message for non-existent channel " + id);
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_FAILURE (" + id + ")");
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 5) {
                c.state = 5;
                c.reasonClosed = "Remote sent failure for this channel";
            }
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenConfirmation(byte[] msg, int msglen) throws IOException {
        PacketChannelOpenConfirmation sm = new PacketChannelOpenConfirmation(msg, 0, msglen);
        Channel c = this.getChannel(sm.recipientChannelID);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for non-existent channel " + sm.recipientChannelID);
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 1) {
                throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for channel " + sm.recipientChannelID);
            }
            c.remoteID = sm.senderChannelID;
            c.remoteWindow = sm.initialWindowSize;
            c.remoteMaxPacketSize = sm.maxPacketSize;
            c.estimatedMaxDataLen = c.remoteMaxPacketSize - 256;
            if (c.estimatedMaxDataLen <= 0) {
                c.estimatedMaxDataLen = 1;
            }
            c.state = 2;
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            int i;
            if (log.isEnabled()) {
                log.log(50, "handleMessage: got shutdown");
            }
            Vector vector = this.listenerThreads;
            synchronized (vector) {
                i = 0;
                while (i < this.listenerThreads.size()) {
                    LocalAcceptThread lat = (LocalAcceptThread)this.listenerThreads.elementAt(i);
                    lat.stopListening();
                    ++i;
                }
                this.listenerThreadsAllowed = false;
            }
            vector = this.channels;
            synchronized (vector) {
                i = 0;
                while (i < this.channels.size()) {
                    Channel c;
                    Channel channel = c = (Channel)this.channels.elementAt(i);
                    synchronized (channel) {
                        c.state = 4;
                        c.reasonClosed = "Connection is being shutdown";
                        c.closeMessageRecv = true;
                        c.notifyAll();
                    }
                    ++i;
                }
                this.channels.setSize(0);
                this.channels.trimToSize();
                return;
            }
        }
        switch (msg[0]) {
            case 91: {
                this.msgChannelOpenConfirmation(msg, msglen);
                break;
            }
            case 93: {
                this.msgChannelWindowAdjust(msg, msglen);
                break;
            }
            case 94: {
                this.msgChannelData(msg, msglen);
                break;
            }
            case 95: {
                this.msgChannelExtendedData(msg, msglen);
                break;
            }
            case 98: {
                this.msgChannelRequest(msg, msglen);
                break;
            }
            case 96: {
                this.msgChannelEOF(msg, msglen);
                break;
            }
            case 97: {
                this.msgChannelClose(msg, msglen);
                break;
            }
            case 99: {
                this.msgChannelSuccess(msg, msglen);
                break;
            }
            case 92: 
            case 100: {
                this.msgChannelFailure(msg, msglen);
                break;
            }
            default: {
                throw new IOException("Cannot handle channel message " + (msg[0] & 0xFF));
            }
        }
    }
}

