/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.DHGexParameters;
import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.LocalStreamForwarder;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.auth.AuthenticationManager;
import ch.ethz.ssh2.channel.ChannelManager;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class Connection {
    public static final String identification = "Ganymed Build_208";
    private AuthenticationManager am;
    private boolean authenticated = false;
    private ChannelManager cm;
    private CryptoWishList cryptoWishList = new CryptoWishList();
    private DHGexParameters dhgexpara = new DHGexParameters();
    private String hostname;
    private int port;
    private TransportManager tm;

    public static synchronized String[] getAvailableCiphers() {
        return BlockCipherFactory.getDefaultCipherList();
    }

    public static synchronized String[] getAvailableMACs() {
        return MAC.getMacList();
    }

    public static synchronized String[] getAvailableServerHostKeyAlgorithms() {
        return KexManager.getDefaultServerHostkeyAlgorithmList();
    }

    public Connection(String hostname) {
        this(hostname, 22);
    }

    public Connection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public synchronized boolean authenticateWithDSA(String user, String pem, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (pem == null) {
            throw new IllegalArgumentException("pem argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(user, pem.toCharArray(), password);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String user, InteractiveCallback cb) throws IOException {
        return this.authenticateWithKeyboardInteractive(user, null, cb);
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String user, String[] submethods, InteractiveCallback cb) throws IOException {
        if (cb == null) {
            throw new IllegalArgumentException("Callback may not ne NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateInteractive(user, submethods, cb);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPassword(String user, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password argument is null");
        }
        this.authenticated = this.am.authenticatePassword(user, password);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String user, char[] pemPrivateKey, String password) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (user == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (pemPrivateKey == null) {
            throw new IllegalArgumentException("pemPrivateKey argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(user, pemPrivateKey, password);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String user, File pemFile, String password) throws IOException {
        int len;
        if (pemFile == null) {
            throw new IllegalArgumentException("pemFile argument is null");
        }
        char[] buff = new char[256];
        CharArrayWriter cw = new CharArrayWriter();
        FileReader fr = new FileReader(pemFile);
        while ((len = fr.read(buff)) >= 0) {
            cw.write(buff, 0, len);
        }
        fr.close();
        return this.authenticateWithPublicKey(user, cw.toCharArray(), password);
    }

    public synchronized void close() {
        if (this.tm != null) {
            Throwable t = new Throwable("Closed due to user request.");
            this.tm.close(t);
            this.tm = null;
        }
        this.am = null;
        this.cm = null;
        this.authenticated = false;
    }

    public synchronized ConnectionInfo connect() throws IOException {
        return this.connect(null);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier verifier) throws IOException {
        if (this.tm != null) {
            throw new IOException("Connection is already in connected state!");
        }
        try {
            this.tm = new TransportManager(this.hostname, this.port);
            this.tm.initialize(this.cryptoWishList, verifier, this.dhgexpara);
            return this.tm.getConnectionInfo(1);
        }
        catch (IOException e1) {
            this.close();
            throw (IOException)new IOException("The connection could not be fully established.").initCause(e1);
        }
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(int local_port, String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, local_port, host_to_connect, port_to_connect);
    }

    public synchronized LocalStreamForwarder createLocalStreamForwarder(String host_to_connect, int port_to_connect) throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward, connection is not authenticated.");
        }
        return new LocalStreamForwarder(this.cm, host_to_connect, port_to_connect);
    }

    public synchronized SCPClient createSCPClient() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot create SCP client, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot create SCP client, connection is not authenticated.");
        }
        return new SCPClient(this);
    }

    public synchronized void forceKeyExchange() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        this.tm.forceKeyExchange(this.cryptoWishList, this.dhgexpara);
    }

    public synchronized ConnectionInfo getConnectionInfo() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getConnectionInfo(1);
    }

    public synchronized String[] getRemainingAuthMethods(String user) throws IOException {
        if (user == null) {
            throw new IllegalArgumentException("user argument may not be NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        return this.am.getRemainingMethods(user);
    }

    public synchronized boolean isAuthenticationComplete() {
        return this.authenticated;
    }

    public synchronized boolean isAuthenticationPartialSuccess() {
        if (this.am == null) {
            return false;
        }
        return this.am.getPartialSuccess();
    }

    public synchronized boolean isAuthMethodAvailable(String user, String method) throws IOException {
        if (method == null) {
            throw new IllegalArgumentException("method argument may not be NULL!");
        }
        String[] methods = this.getRemainingAuthMethods(user);
        int i = 0;
        while (i < methods.length) {
            if (methods[i].compareTo(method) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized Session openSession() throws IOException {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot open session, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot open session, connection is not authenticated.");
        }
        return new Session(this.cm);
    }

    private String[] removeDuplicates(String[] list) {
        if (list == null || list.length < 2) {
            return list;
        }
        String[] list2 = new String[list.length];
        int count = 0;
        int i = 0;
        while (i < list.length) {
            boolean duplicate = false;
            String element = list[i];
            int j = 0;
            while (j < count) {
                if (element == null && list2[j] == null || element != null && element.equals(list2[j])) {
                    duplicate = true;
                    break;
                }
                ++j;
            }
            if (!duplicate) {
                list2[count++] = list[i];
            }
            ++i;
        }
        if (count == list2.length) {
            return list2;
        }
        String[] tmp = new String[count];
        System.arraycopy(list2, 0, tmp, 0, count);
        return tmp;
    }

    public synchronized void setClient2ServerCiphers(String[] ciphers) {
        if (ciphers == null || ciphers.length == 0) {
            throw new IllegalArgumentException();
        }
        ciphers = this.removeDuplicates(ciphers);
        BlockCipherFactory.checkCipherList(ciphers);
        this.cryptoWishList.c2s_enc_algos = ciphers;
    }

    public synchronized void setClient2ServerMACs(String[] macs) {
        if (macs == null || macs.length == 0) {
            throw new IllegalArgumentException();
        }
        macs = this.removeDuplicates(macs);
        MAC.checkMacList(macs);
        this.cryptoWishList.c2s_mac_algos = macs;
    }

    public synchronized void setDHGexParameters(DHGexParameters dgp) {
        if (dgp == null) {
            throw new IllegalArgumentException();
        }
        this.dhgexpara = dgp;
    }

    public synchronized void setServer2ClientCiphers(String[] ciphers) {
        if (ciphers == null || ciphers.length == 0) {
            throw new IllegalArgumentException();
        }
        ciphers = this.removeDuplicates(ciphers);
        BlockCipherFactory.checkCipherList(ciphers);
        this.cryptoWishList.s2c_enc_algos = ciphers;
    }

    public synchronized void setServer2ClientMACs(String[] macs) {
        if (macs == null || macs.length == 0) {
            throw new IllegalArgumentException();
        }
        macs = this.removeDuplicates(macs);
        MAC.checkMacList(macs);
        this.cryptoWishList.s2c_mac_algos = macs;
    }

    public synchronized void setServerHostKeyAlgorithms(String[] algos) {
        if (algos == null || algos.length == 0) {
            throw new IllegalArgumentException();
        }
        algos = this.removeDuplicates(algos);
        KexManager.checkServerHostkeyAlgorithmsList(algos);
        this.cryptoWishList.serverHostKeyAlgorithms = algos;
    }
}

