/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.id3v2.datatypes.TimeCode;
import de.ueberdosis.util.OutputCtr;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Helper
implements Defines {
    public static long unsynchsafe(byte[] byArray) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (long i = (long)(byArray.length - 1); i >= 0L; --i) {
            l2 = byArray[(int)i] & 0xFF;
            l += l2 * Helper.pow(2L, l3 * 7L);
            ++l3;
        }
        return l;
    }

    public static byte[] synchsafe(long l, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            byArray[i] = (byte)(l >> n2 * 7 & 0x7FL);
            ++n2;
        }
        return byArray;
    }

    public static long pow(long l, long l2) {
        long l3 = 1L;
        for (long i = 1L; i <= l2; ++i) {
            l3 *= l;
        }
        return l3;
    }

    public static int decodeBytesToInt(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n2 = byArray[i] & 0xFF;
            n3 = byArray.length - 1 - i;
            n = (int)((long)n + (long)n2 * Helper.pow(2L, n3 * 8));
        }
        return n;
    }

    public static String arrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer().append("0x");
        for (int i = byArray.length; i > 0; --i) {
            stringBuffer.append("0123456789ABCDEF".charAt(0xF & byArray[i - 1] >> 4)).append("0123456789ABCDEF".charAt(byArray[i - 1] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String byteToHexString(byte by) {
        return "0x" + "0123456789ABCDEF".charAt(0xF & by >> 4) + "0123456789ABCDEF".charAt(by & 0xF);
    }

    public static String byteToHexString(int n) {
        if (n >= 0 && n <= 255) {
            return Helper.byteToHexString(Helper.unsignedIntToByte(n));
        }
        return "Can't convert " + n + " to byte!";
    }

    public static int byteToUnsignedInt(byte by) {
        return by & 0xFF;
    }

    public static byte unsignedIntToByte(int n) {
        if (n >= 0 && n < 128) {
            return (byte)n;
        }
        if (n >= 128 && n < 255) {
            return (byte)(n - 256);
        }
        return -128;
    }

    public static byte[] reallocateByteBuffer(int n) {
        return Helper.reallocateByteBuffer(n, null);
    }

    public static byte[] reallocateByteBuffer(int n, byte[] byArray) {
        byte[] byArray2 = null;
        int n2 = 0;
        if (byArray != null) {
            n2 += byArray.length;
        }
        byArray2 = new byte[n2 += n];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    public static String getStringEncoding(byte by) {
        String string = "";
        switch (by) {
            case 0: {
                string = "ISO-8859-1";
                break;
            }
            case 1: {
                string = "UTF-16";
                break;
            }
            case 2: {
                string = "UTF-16BE";
                break;
            }
            case 3: {
                string = "UTF-8";
            }
        }
        return string;
    }

    public static boolean isValidEncoding(byte by) {
        return Helper.getStringEncoding(by) != "";
    }

    public static byte getByteEncoding(String string) {
        if ("ISO-8859-1".equals(string)) {
            return 0;
        }
        if ("UTF-16".equals(string)) {
            return 1;
        }
        if ("UTF-16BE".equals(string)) {
            return 2;
        }
        if ("UTF-8".equals(string)) {
            return 3;
        }
        return 0;
    }

    public static String byteArrayToString(byte[] byArray, byte by) {
        String string = "";
        if (byArray.length <= 0) {
            return string;
        }
        try {
            string = new String(byArray, Helper.getStringEncoding(by));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputCtr.println(1, "Unsupported Encoding " + Helper.getStringEncoding(by) + " (" + by + ") encountered, defaulting to" + Configuration.defaultEncoding);
            try {
                string = new String(byArray, Configuration.defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                OutputCtr.println(1, "Unsupported default encoding " + Configuration.defaultEncoding + " encountered. Using system default.");
                string = new String(byArray);
            }
        }
        return string;
    }

    public static byte[] stringToByteArray(String string, byte by) {
        try {
            return string.getBytes(Helper.getStringEncoding(by));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputCtr.println(0, "Unsupported Encoding " + by + " encountered.");
            OutputCtr.println(0, unsupportedEncodingException);
            return new byte[0];
        }
    }

    public static int getStringDelimiterSize(byte by) {
        switch (by) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        if (Helper.isValidEncoding(Helper.getByteEncoding(Configuration.defaultEncoding))) {
            return Helper.getStringDelimiterSize(Helper.getByteEncoding(Configuration.defaultEncoding));
        }
        OutputCtr.println(0, "Unsupported encoding " + by + " encountered.");
        return 1;
    }

    public static byte[] getStringBytes(String string, byte by) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(Helper.getStringEncoding(by));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    public static byte[] timeCodeToSYTC(TimeCode timeCode) {
        byte[] byArray = timeCode.getBpm() > 255 ? Helper.reallocateByteBuffer(6) : Helper.reallocateByteBuffer(5);
        byte[] byArray2 = Helper.intToByteArray(timeCode.getTimeStamp(), 4);
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        if (timeCode.getBpm() > 255) {
            byArray[4] = -127;
            byArray[5] = (byte)(timeCode.getBpm() - 255);
        } else {
            byArray[4] = (byte)timeCode.getBpm();
        }
        return byArray;
    }

    public static byte[] intToByteArray(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = n2; i > 0; --i) {
            byArray[i - 1] = (byte)n;
            n >>>= 8;
        }
        return byArray;
    }

    public static byte[] intToByteArray(int n) {
        Vector<Byte> vector = new Vector<Byte>();
        byte by = 0;
        do {
            by = (byte)n;
            vector.add(new Byte(by));
        } while ((n >>>= 8) > 0);
        int n2 = vector.size();
        byte[] byArray = new byte[n2];
        for (int i = n2; i > 0; --i) {
            byArray[i - 1] = (Byte)vector.elementAt(n2 - i);
        }
        return byArray;
    }
}

