/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.UndersizedException;
import de.ueberdosis.mp3info.id3v2.Helper;

public class Header
implements Defines {
    private String identifier;
    private int version;
    private int revision;
    private int flags;
    private boolean unsynchronisation = false;
    private boolean extendedHeader = false;
    private boolean experimentalIndicator = false;
    private boolean footerPresent = false;
    private boolean unknownFlagsExist = false;
    private long size;

    public Header() {
        this.identifier = "ID3";
        this.version = 3;
        this.revision = 0;
        this.flags = 0;
    }

    public Header(Header header) {
        this.identifier = new String(header.identifier);
        this.version = header.version;
        this.revision = header.revision;
        this.flags = header.flags;
        this.unsynchronisation = header.unsynchronisation;
        this.extendedHeader = header.extendedHeader;
        this.experimentalIndicator = header.experimentalIndicator;
        this.footerPresent = header.footerPresent;
        this.unknownFlagsExist = header.unknownFlagsExist;
        this.size = header.size;
    }

    public Header(byte[] byArray) throws UndersizedException {
        if (byArray.length < 10) {
            throw new UndersizedException(byArray.length, 10);
        }
        this.identifier = new String(byArray, 0, 3);
        this.version = byArray[3] & 0xFF;
        this.revision = byArray[4] & 0xFF;
        this.flags = byArray[5] & 0xFF;
        this.unsynchronisation = (byArray[5] & 0x80) != 0;
        this.extendedHeader = (byArray[5] & 0x40) != 0;
        this.experimentalIndicator = (byArray[5] & 0x20) != 0;
        this.footerPresent = (byArray[5] & 0x10) != 0;
        this.unknownFlagsExist = (byArray[5] & 0xF) != 0;
        byte[] byArray2 = new byte[]{byArray[6], byArray[7], byArray[8], byArray[9]};
        this.size = Helper.unsynchsafe(byArray2);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean hasUnsynchronisation() {
        return this.unsynchronisation;
    }

    public boolean hasExtendedHeader() {
        return this.extendedHeader;
    }

    public boolean isExperimental() {
        return this.experimentalIndicator;
    }

    public boolean hasFooter() {
        return this.footerPresent;
    }

    public boolean hasUnknownFlags() {
        return this.unknownFlagsExist;
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This ID3V2Tag seems to be:\n").append("Identifier: ").append(this.identifier).append("\n").append("Version:    ").append(this.version).append(".").append(this.revision).append("\n").append("Flags:      ").append(Integer.toString(this.flags, 2)).append("\n").append("unsynch ").append(this.unsynchronisation).append(", exthead ").append(this.extendedHeader).append(", exp'tal ").append(this.experimentalIndicator).append(", footer  ").append(this.footerPresent).append(", unknown ").append(this.unknownFlagsExist).append("\n").append("Size (without header or footer): ").append(this.size).append("\n");
        return stringBuffer.toString();
    }
}

