/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameUSER
extends ID3V2Frame {
    private byte encoding = 0;
    private String language = "";
    private String text = "";

    public String getLongName() {
        return "Terms of use frame";
    }

    public FrameUSER(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameUSER) {
            FrameUSER frameUSER = (FrameUSER)iD3V2Frame;
            this.encoding = frameUSER.encoding;
            this.language = frameUSER.language;
            this.text = frameUSER.text;
        }
    }

    public FrameUSER(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.language = new String(dataSource.getBytes(3L));
            this.text = new String(dataSource.getBytes(dataSource.getBytesLeft()));
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        byte[] byArray = this.language.getBytes();
        byte[] byArray2 = Helper.getStringBytes(this.text, this.encoding);
        byte[] byArray3 = Helper.reallocateByteBuffer(4 + byArray2.length);
        byArray3[0] = this.encoding;
        System.arraycopy(byArray, 0, byArray3, 1, 3);
        System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
        return byArray3;
    }

    public String toString() {
        return this.getLongName() + "\nEncoding: " + this.encoding + "\nLanguage:  " + this.language + "\nText: " + this.text;
    }
}

