/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.mp3info.id3v2.datatypes.TimeCode;
import de.ueberdosis.util.OutputCtr;
import java.util.Enumeration;
import java.util.Vector;

public class FrameSYTC
extends ID3V2Frame {
    private byte[] codes;
    private Vector tempoCodes = new Vector();
    private int timeStampFormat = 0;
    public static final String[] timeFormats = new String[]{"N/A", "Absolute time, 32 bit sized, using MPEG frames as unit", "Absolute time, 32 bit sized, using milliseconds as unit", "N/A"};

    public String getLongName() {
        return "Synchronized tempo codes frame";
    }

    public FrameSYTC(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
    }

    public FrameSYTC(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.timeStampFormat = dataSource.getByte() & 0xFF;
            this.codes = dataSource.getBytes(dataSource.getBytesLeft());
            this.decodeCodeData();
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    private void decodeCodeData() {
        int n = 0;
        TimeCode timeCode = null;
        while (n < this.codes.length) {
            timeCode = new TimeCode();
            byte[] byArray = new byte[]{this.codes[n], this.codes[n + 1], this.codes[n + 2], this.codes[n + 3]};
            timeCode.setTimeStamp(Helper.decodeBytesToInt(byArray));
            if (this.codes[n + 4] == 255) {
                timeCode.setBpm(255 + (this.codes[n + 5] & 0xFF));
                n += 5;
            } else {
                timeCode.setBpm(this.codes[n + 4] & 0xFF);
                n += 4;
            }
            this.tempoCodes.addElement(timeCode);
        }
    }

    public String toString() {
        return this.getLongName() + "\nNumber of events : " + this.tempoCodes.size();
    }

    public byte[] getData() {
        Enumeration enumeration = this.tempoCodes.elements();
        TimeCode timeCode = null;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            timeCode = (TimeCode)enumeration.nextElement();
            n += timeCode.getBpm() > 255 ? 4 : 5;
        }
        byte[] byArray = new byte[n + 1];
        byArray[0] = (byte)this.timeStampFormat;
        int n2 = 1;
        enumeration = this.tempoCodes.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray2 = Helper.timeCodeToSYTC((TimeCode)enumeration.nextElement());
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }
}

