/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.mp3info.id3v2.datatypes.TextData;
import de.ueberdosis.util.OutputCtr;
import java.util.Vector;

public class FrameSYLT
extends ID3V2Frame {
    private byte encoding = 0;
    private byte timeStampFormat = 0;
    private String language = "";
    private String description = "";
    private byte contentType = 0;
    private Vector texts = new Vector();
    private byte[] data = null;

    public String getLongName() {
        return "Sychronised lyrics/text transcription frame";
    }

    public FrameSYLT(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
    }

    public FrameSYLT(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.language = new String(dataSource.getBytes(3L));
            this.timeStampFormat = dataSource.getByte();
            this.contentType = dataSource.getByte();
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.description = new String(byArray);
            }
            dataSource.getByte();
            this.data = dataSource.getBytes(dataSource.getBytesLeft());
            this.decodeData();
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    private void decodeData() {
        int n = 0;
        int n2 = 0;
        while (n < this.data.length) {
            TextData textData = new TextData();
            byte[] byArray = Helper.reallocateByteBuffer(40, null);
            boolean bl = false;
            n2 = 0;
            while (n + n2 < this.data.length && !bl) {
                byte by = this.data[n + n2];
                if (by != 0) {
                    if (n2 >= byArray.length) {
                        byArray = Helper.reallocateByteBuffer(40, byArray);
                    }
                    if (byArray != null) {
                        byArray[n2] = by;
                    }
                } else {
                    bl = true;
                }
                ++n2;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            textData.setTimeStamp(Helper.decodeBytesToInt(new byte[]{this.data[n += n2], this.data[n + 1], this.data[n + 2], this.data[n + 3]}));
            this.texts.addElement(textData);
        }
    }

    public String toString() {
        return this.getLongName() + " Encoding: " + this.encoding + "\nlanguage: " + this.language + "\nEntries: " + this.texts.size();
    }

    public byte[] getData() {
        return null;
    }
}

