/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FramePOSS
extends ID3V2Frame {
    private byte timeStampFormat = 0;
    private int position = 0;

    public String getLongName() {
        return "Position synchronisation frame";
    }

    public FramePOSS(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FramePOSS) {
            FramePOSS framePOSS = (FramePOSS)iD3V2Frame;
            this.timeStampFormat = framePOSS.timeStampFormat;
            this.position = framePOSS.position;
        }
    }

    public FramePOSS(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.timeStampFormat = dataSource.getByte();
            this.position = Helper.decodeBytesToInt(dataSource.getBytes(dataSource.getBytesLeft()));
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[5];
        byArray[0] = this.timeStampFormat;
        byte[] byArray2 = Helper.intToByteArray(this.position, 4);
        System.arraycopy(byArray2, 0, byArray, 1, 4);
        return byArray;
    }

    public String toString() {
        return this.getLongName() + "\ntimeStampFormat: " + this.timeStampFormat + "\nPosition:  " + this.position;
    }
}

