/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameMCDI
extends ID3V2Frame {
    private byte[] identifier;

    public String getLongName() {
        return "Music CD identifier frame";
    }

    public FrameMCDI(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameMCDI) {
            FrameMCDI frameMCDI = (FrameMCDI)iD3V2Frame;
            this.identifier = new byte[frameMCDI.identifier.length];
            System.arraycopy(frameMCDI.identifier, 0, this.identifier, 0, frameMCDI.identifier.length);
        }
    }

    public FrameMCDI(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.identifier = dataSource.getBytes(dataSource.getBytesLeft());
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        return this.identifier;
    }

    public String toString() {
        return this.getLongName() + "\nIdentifier : " + Helper.arrayToHexString(this.identifier);
    }
}

