/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.io.UnsupportedEncodingException;

public class FrameENCR
extends ID3V2Frame {
    private String ownerIdentifier = "";
    private byte methodSymbol = 0;
    private byte[] encryptionData = null;

    public byte[] getData() {
        byte[] byArray;
        try {
            byArray = this.ownerIdentifier.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputCtr.println(4, unsupportedEncodingException);
            byArray = this.ownerIdentifier.getBytes();
        }
        byte[] byArray2 = Helper.reallocateByteBuffer(byArray.length + 2 + this.encryptionData.length, null);
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[byArray.length] = 0;
        byArray2[byArray.length + 1] = this.methodSymbol;
        System.arraycopy(this.encryptionData, 0, byArray2, byArray.length + 2, this.encryptionData.length);
        return byArray2;
    }

    public String getLongName() {
        return "Encryption method registration frame";
    }

    public FrameENCR(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameENCR) {
            FrameENCR frameENCR = (FrameENCR)iD3V2Frame;
            this.ownerIdentifier = frameENCR.ownerIdentifier;
            this.methodSymbol = frameENCR.methodSymbol;
            this.encryptionData = new byte[frameENCR.encryptionData.length];
            System.arraycopy(frameENCR.encryptionData, 0, this.encryptionData, 0, frameENCR.encryptionData.length);
        }
    }

    public FrameENCR(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.ownerIdentifier = new String(byArray);
            }
            dataSource.getByte();
            this.methodSymbol = dataSource.getByte();
            this.encryptionData = dataSource.getBytes(dataSource.getBytesLeft());
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public String toString() {
        return this.getLongName() + "\n Better toString () to follow!";
    }
}

