/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameCOMR
extends ID3V2Frame {
    private byte encoding = 0;
    private String price = "";
    private String validUntil = "";
    private String contactURL = "";
    private byte received = 0;
    private String sellerName = "";
    private String description = "";
    private String pictureType = "";
    private byte[] sellerLogo = null;

    public String getLongName() {
        return "Commercial frame";
    }

    FrameCOMR(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameCOMR) {
            FrameCOMR frameCOMR = (FrameCOMR)iD3V2Frame;
            this.encoding = frameCOMR.encoding;
            this.price = frameCOMR.price;
            this.validUntil = frameCOMR.validUntil;
            this.contactURL = frameCOMR.contactURL;
            this.received = frameCOMR.received;
            this.sellerName = frameCOMR.sellerName;
            this.description = frameCOMR.description;
            this.pictureType = frameCOMR.pictureType;
            this.sellerLogo = new byte[frameCOMR.sellerLogo.length];
            System.arraycopy(frameCOMR.sellerLogo, 0, this.sellerLogo, 0, frameCOMR.sellerLogo.length);
        }
    }

    public FrameCOMR(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.price = new String(byArray);
            }
            dataSource.getByte();
            this.validUntil = new String(dataSource.getBytes(8L));
            byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.contactURL = new String(byArray);
            }
            dataSource.getByte();
            this.received = dataSource.getByte();
            try {
                this.sellerName = dataSource.readString(this.encoding);
            }
            catch (DatamismatchException datamismatchException) {
                // empty catch block
            }
            try {
                this.description = dataSource.readString(this.encoding);
            }
            catch (DatamismatchException datamismatchException) {
                // empty catch block
            }
            byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.pictureType = new String(byArray);
            }
            dataSource.getByte();
            this.sellerLogo = dataSource.getBytes(dataSource.getBytesLeft());
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public byte[] getData() {
        return null;
    }

    public String toString() {
        return this.getLongName() + "\n Better toString () to follow!";
    }
}

