/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.gui.EncDescValJPanel;
import de.ueberdosis.mp3info.gui.Id3JPanel;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.EncDescValFrame;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.Languages;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameCOMM
extends ID3V2Frame
implements EncDescValFrame {
    private byte encoding = 0;
    private String language = "eng";
    private String description = "";
    private String text = "";
    private static final String caption1 = "Comment description";
    private static final String caption2 = "Comment";

    public String getLongName() {
        return "Comments frame";
    }

    public FrameCOMM() {
        super("COMM");
    }

    public FrameCOMM(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameCOMM) {
            FrameCOMM frameCOMM = (FrameCOMM)iD3V2Frame;
            this.encoding = frameCOMM.encoding;
            this.language = frameCOMM.language;
            this.description = frameCOMM.description;
            this.text = frameCOMM.text;
        }
    }

    public FrameCOMM(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            this.language = new String(dataSource.getBytes(3L));
            this.description = dataSource.readString(this.encoding);
            this.text = dataSource.readString(this.encoding);
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, "Text frame can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
        catch (DatamismatchException datamismatchException) {
            OutputCtr.println(0, "Encountered an illegal encoding " + this.encoding);
        }
        if (!Languages.checkLanguage(this.language)) {
            this.language = Configuration.defaultLanguage;
        }
    }

    public String toString() {
        return this.getLongName() + " Encoding: " + this.encoding + "\nlanguage: " + this.language + "\ndescription: " + this.description + "\ntext: " + this.text;
    }

    public boolean containsData() {
        return this.description.length() > 0 || this.text.length() > 0;
    }

    public byte[] getData() {
        byte[] byArray = Helper.stringToByteArray(this.description, this.encoding);
        byte[] byArray2 = Helper.stringToByteArray(this.text, this.encoding);
        int n = Helper.getStringDelimiterSize(this.encoding);
        byte[] byArray3 = new byte[4 + byArray.length + n + byArray2.length];
        byArray3[0] = this.encoding;
        byArray3[1] = (byte)this.language.charAt(0);
        byArray3[2] = (byte)this.language.charAt(1);
        byArray3[3] = (byte)this.language.charAt(2);
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        for (int i = 4 + byArray.length; i < 4 + byArray.length + n; ++i) {
            byArray3[i] = 0;
        }
        System.arraycopy(byArray2, 0, byArray3, 4 + byArray.length + n, byArray2.length);
        return byArray3;
    }

    public boolean canEdit() {
        return true;
    }

    public boolean canDisplay() {
        return true;
    }

    public Id3JPanel createJPanel(boolean bl, boolean bl2) {
        return new EncDescValJPanel(bl, bl2, caption1, this.description, caption2, this.text, this);
    }

    public void setDescription(String string) {
        if (!string.equals(this.description)) {
            this.dataChanged = true;
        }
        this.description = string.trim();
    }

    public void setValue(String string) {
        this.setText(string);
    }

    public String getValue() {
        return this.getText();
    }

    public void setText(String string) {
        if (!string.equals(this.text)) {
            this.text = string.trim();
            this.dataChanged = true;
        }
    }

    public String getText() {
        return this.text;
    }
}

