/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;

public class FrameAPIC
extends ID3V2Frame {
    private byte encoding = 0;
    private String mimeType = "";
    private byte pictureType = 0;
    private String description = "";
    private byte[] pictureData = null;
    public static final String[] pictureTypes = new String[]{"Other", "32x32 pixels 'file icon' (PNG only)", "Other file icon", "Cover (front)", "Cover (back)", "Leaflet page", "Media (e.g. lable side of CD)", "Lead artist/lead performer/soloist", "Artist/performer", "Conductor", "Band/Orchestra", "Composer", "Lyricist/text writer", "Recording Location", "During recording", "During performance", "Movie/video screen capture", "A bright coloured fish", "Illustration", "Band/artist logotype", "Publisher/Studio logotype"};

    public String getLongName() {
        return "Attached Picture frame";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public void setEncoding(byte by) {
        this.encoding = by;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String string) {
        this.mimeType = string;
    }

    public byte[] getPictureData() {
        return this.pictureData;
    }

    public void setPictureData(byte[] byArray) {
        this.pictureData = byArray;
    }

    public byte getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(byte by) {
        this.pictureType = by;
    }

    public boolean containsData() {
        return this.pictureData != null && this.pictureData.length > 0;
    }

    public int legalSince() {
        return 3;
    }

    public FrameAPIC(ID3V2Frame iD3V2Frame) {
        super(iD3V2Frame);
        if (iD3V2Frame instanceof FrameAPIC) {
            FrameAPIC frameAPIC = (FrameAPIC)iD3V2Frame;
            this.encoding = frameAPIC.encoding;
            this.mimeType = frameAPIC.mimeType;
            this.pictureType = frameAPIC.pictureType;
            this.description = frameAPIC.description;
            this.pictureData = new byte[frameAPIC.pictureData.length];
            System.arraycopy(frameAPIC.pictureData, 0, this.pictureData, 0, frameAPIC.pictureData.length);
        }
    }

    public FrameAPIC(ID3V2Frame iD3V2Frame, DataSource dataSource) throws SeekPastEndException {
        super(iD3V2Frame);
        try {
            this.encoding = dataSource.getByte();
            byte[] byArray = dataSource.getBytesTo((byte)0);
            if (byArray != null) {
                this.mimeType = new String(byArray);
            }
            dataSource.getByte();
            this.pictureType = dataSource.getByte();
            try {
                this.description = dataSource.readString(this.encoding);
            }
            catch (DatamismatchException datamismatchException) {
                OutputCtr.println(1, datamismatchException);
            }
            this.pictureData = dataSource.getBytes(dataSource.getBytesLeft());
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, this.getLongName() + " can't be instantiated! SPEEx!");
            throw seekPastEndException;
        }
    }

    public String toString() {
        return this.getLongName() + "\nDescription: " + this.description + "\nPicture type: " + pictureTypes[this.pictureType] + "\nMIME Type: " + this.mimeType + "\n";
    }

    public byte[] getData() {
        byte[] byArray = this.mimeType.getBytes();
        byte[] byArray2 = Helper.stringToByteArray(this.description, this.encoding);
        int n = Helper.getStringDelimiterSize(this.encoding);
        byte[] byArray3 = Helper.reallocateByteBuffer(3 + n + byArray.length + byArray2.length + this.pictureData.length, null);
        byArray3[0] = this.encoding;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        byArray3[byArray.length + 1] = 0;
        byArray3[byArray.length + 2] = this.pictureType;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 3, byArray2.length);
        for (int i = 1; i <= n; ++i) {
            byArray3[byArray.length + 3 + byArray2.length + i] = 0;
        }
        System.arraycopy(this.pictureData, 0, byArray3, 3 + n + byArray2.length + byArray.length, this.pictureData.length);
        return byArray3;
    }
}

