/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.DatamismatchException;
import de.ueberdosis.mp3info.id3v2.DataSource;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.mp3info.id3v2.ID3V2Frame;
import de.ueberdosis.mp3info.id3v2.SeekPastEndException;
import de.ueberdosis.util.OutputCtr;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class FileFrameDataSource
implements DataSource {
    RandomAccessFile raf = null;
    long startPosition = 0L;
    long internalPosition = 0L;
    long size = 0L;

    public FileFrameDataSource(ID3V2Frame iD3V2Frame, RandomAccessFile randomAccessFile) {
        this.startPosition = iD3V2Frame.getPosition() + 10L;
        this.size = iD3V2Frame.getSize();
        this.raf = randomAccessFile;
    }

    public byte getByte() throws SeekPastEndException {
        return this.getBytes(1L)[0];
    }

    public byte[] getBytes(long l) throws SeekPastEndException {
        byte[] byArray = new byte[]{0};
        if (this.internalPosition + l <= this.size) {
            byArray = this.readBytes(l);
            this.internalPosition += l;
        } else {
            throw new SeekPastEndException(this.internalPosition + l + " >= " + this.size);
        }
        return byArray;
    }

    public byte[] getBytesTo(byte by) {
        OutputCtr.println(7, "StopByte: " + by + " internal counter: " + this.internalPosition);
        byte[] byArray = Helper.reallocateByteBuffer(256, null);
        byte[] byArray2 = null;
        int n = 0;
        boolean bl = false;
        byte by2 = 0;
        try {
            if (byArray != null) {
                OutputCtr.println(6, "initial bAr got..");
                while (this.hasMoreBytes() && !bl) {
                    by2 = this.getByte();
                    if (by2 != by) {
                        if (++n >= byArray.length && (byArray = Helper.reallocateByteBuffer(256, byArray)) == null) {
                            OutputCtr.print(5, " Reallocation of buffer failed");
                            return null;
                        }
                        byArray[n - 1] = by2;
                        continue;
                    }
                    bl = true;
                }
            } else {
                return null;
            }
            if (n > 0) {
                byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                OutputCtr.println(7, "Resultarray is " + byArray2.length + " bytes.");
            } else {
                OutputCtr.println(6, "No byte read.");
                byArray2 = null;
            }
            --this.internalPosition;
        }
        catch (SeekPastEndException seekPastEndException) {
            OutputCtr.println(0, seekPastEndException);
        }
        OutputCtr.println(7, "Everything went fine...");
        OutputCtr.println(7, "internal counter: " + this.internalPosition);
        return byArray2;
    }

    public void reset() {
        this.internalPosition = 0L;
    }

    public boolean hasMoreBytes() {
        return this.internalPosition < this.size;
    }

    public long getBytesLeft() {
        return this.size - this.internalPosition;
    }

    public void seek(long l) throws SeekPastEndException {
        if (l >= this.size) {
            throw new SeekPastEndException(l + " >= " + this.size);
        }
        this.internalPosition = l;
    }

    public void seekRelative(long l) throws SeekPastEndException {
        this.seek(this.internalPosition + l);
    }

    private byte[] readBytes(long l) throws SeekPastEndException {
        try {
            byte[] byArray = new byte[(int)l];
            this.raf.seek(this.startPosition + this.internalPosition);
            this.raf.read(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            throw new SeekPastEndException(iOException.getMessage());
        }
    }

    public String readString(byte by) throws DatamismatchException {
        int n = 1;
        String string = "";
        byte by2 = 0;
        byte by3 = 0;
        int n2 = 0;
        switch (by) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                throw new DatamismatchException("Requested encoding \"" + by + "\" unknown.");
            }
        }
        byte[] byArray = Helper.reallocateByteBuffer(256, null);
        try {
            if (n == 1) {
                by3 = this.getByte();
                while (by3 != 0) {
                    if (byArray.length >= n2) {
                        byArray = Helper.reallocateByteBuffer(256, byArray);
                    }
                    byArray[n2++] = by3;
                    by3 = this.getByte();
                }
            } else if (n == 2) {
                by2 = 1;
                by3 = this.getByte();
                while (by3 != 0 && by2 != 0) {
                    if (byArray.length >= n2) {
                        byArray = Helper.reallocateByteBuffer(256, byArray);
                    }
                    byArray[n2++] = by3;
                    by2 = by3;
                    by3 = this.getByte();
                }
            }
        }
        catch (SeekPastEndException seekPastEndException) {
            // empty catch block
        }
        byte[] byArray2 = Helper.reallocateByteBuffer(n2 - (n - 1), null);
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            string = new String(byArray2, Helper.getStringEncoding(by));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputCtr.println(0, "*** Internal Error ***");
            OutputCtr.println(0, unsupportedEncodingException);
        }
        return string;
    }
}

