/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info.id3v2;

import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.mp3info.UndersizedException;
import de.ueberdosis.mp3info.id3v2.Header;
import de.ueberdosis.mp3info.id3v2.Helper;
import de.ueberdosis.util.OutputCtr;

public class ExtendedHeader
extends Header
implements Defines {
    private boolean tagIsUpdate = false;
    private boolean crcDataPresent = false;
    private boolean tagRestrictions = false;

    public ExtendedHeader(byte[] byArray) throws UndersizedException {
        super(byArray);
        if (byArray.length < 10) {
            throw new UndersizedException(byArray.length, 10);
        }
        long l = Helper.unsynchsafe(new byte[]{byArray[10], byArray[11], byArray[12], byArray[13]});
        if ((long)byArray.length < l + 10L) {
            throw new UndersizedException("Extended decoding had too little data.", byArray.length, (int)l + 10);
        }
        int n = byArray[14] & 0xFF;
        if (n > 10) {
            OutputCtr.println(1, "Possible data loss, can only understand 10 bytes of flags in an extended Header!");
        } else {
            this.tagIsUpdate = (byArray[15] & 0x40) != 0;
            this.crcDataPresent = (byArray[15] & 0x20) != 0;
            this.tagRestrictions = (byArray[15] & 0x10) != 0;
        }
    }
}

