/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info;

import de.ueberdosis.mp3info.Configuration;
import de.ueberdosis.mp3info.Defines;
import de.ueberdosis.util.OutputCtr;
import java.io.UnsupportedEncodingException;

public class ID3Tag
implements Defines {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private byte genre;
    private byte track;
    private boolean validTag = false;
    public static final String[] genres = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychedelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhytmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "Acapella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "Jpop", "Synthpop", "unknown"};

    public ID3Tag(byte[] byArray) {
        this();
        try {
            if ((char)byArray[0] == 'T' && (char)byArray[1] == 'A' && (char)byArray[2] == 'G') {
                this.setTitle(new String(byArray, 3, 30, Configuration.defaultEncoding));
                this.setArtist(new String(byArray, 33, 30, Configuration.defaultEncoding));
                this.setAlbum(new String(byArray, 63, 30, Configuration.defaultEncoding));
                this.setYear(new String(byArray, 93, 4, Configuration.defaultEncoding));
                this.setComment(new String(byArray, 97, 28, Configuration.defaultEncoding));
                this.setTrack(byArray[126]);
                this.setGenre(byArray[127]);
                this.validTag = true;
            } else {
                this.validTag = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputCtr.println(0, "Error in the encoding!");
        }
    }

    public ID3Tag() {
        this.setTitle("");
        this.setArtist("");
        this.setAlbum("");
        this.setYear("");
        this.setComment("");
        this.setGenre((byte)126);
        this.setTrack((byte)0);
        this.validTag = true;
    }

    public ID3Tag(ID3Tag iD3Tag) {
        this.setTitle(iD3Tag.getTitle());
        this.setArtist(iD3Tag.getArtist());
        this.setAlbum(iD3Tag.getAlbum());
        this.setYear(iD3Tag.getYear());
        this.setComment(iD3Tag.getComment());
        this.setGenre(iD3Tag.getGenre());
        this.setTrack(iD3Tag.getTrack());
        this.validTag = true;
    }

    private static byte[] getPaddedByteArray(String string, int n) {
        byte[] byArray;
        OutputCtr.println(2, "Padding \"" + string + "\" to " + n);
        try {
            byArray = string.trim().getBytes(Configuration.defaultEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            OutputCtr.println(0, "System doesn't understand \"" + Configuration.defaultEncoding + "\" ?");
            byArray = string.trim().getBytes();
        }
        byte[] byArray2 = new byte[n];
        if (string.length() != 0) {
            if (byArray.length < n) {
                int n2;
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    byArray2[n2] = byArray[n2];
                }
                for (n2 = byArray.length; n2 < n; ++n2) {
                    byArray2[n2] = 0;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    byArray2[i] = byArray[i];
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byArray2[i] = 0;
            }
        }
        return byArray2;
    }

    private String truncate(String string, int n) {
        String string2 = string.length() > n ? string.substring(0, n - 1) : string;
        return string2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = this.truncate(string.trim(), 30);
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String string) {
        this.artist = this.truncate(string.trim(), 30);
    }

    public String getAlbum() {
        return this.album;
    }

    public void setAlbum(String string) {
        this.album = this.truncate(string.trim(), 30);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String string) {
        this.year = this.truncate(string.trim(), 4);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = this.truncate(string.trim(), 30);
    }

    public byte getGenre() {
        return this.genre;
    }

    public String getGenreS() {
        if (this.genre >= genres.length) {
            return "unknown";
        }
        return genres[this.genre];
    }

    public void setGenre(byte by) {
        this.genre = by;
    }

    public void setGenre(int n) {
        this.setGenre((byte)n);
    }

    public byte getTrack() {
        return this.track;
    }

    public String getTrackS() {
        return "" + (this.track & 0xFF);
    }

    public void setTrack(byte by) {
        this.track = by;
    }

    public void setTrack(int n) {
        this.setTrack((byte)n);
    }

    public boolean isValidTag() {
        return this.validTag;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[128];
        int n = 0;
        byArray[0] = 84;
        byArray[1] = 65;
        byArray[2] = 71;
        byte[] byArray2 = ID3Tag.getPaddedByteArray(this.getTitle(), 30);
        for (n = 0; n < 30; ++n) {
            byArray[n + 3] = byArray2[n];
        }
        byArray2 = ID3Tag.getPaddedByteArray(this.getArtist(), 30);
        for (n = 0; n < 30; ++n) {
            byArray[n + 33] = byArray2[n];
        }
        byArray2 = ID3Tag.getPaddedByteArray(this.getAlbum(), 30);
        for (n = 0; n < 30; ++n) {
            byArray[n + 63] = byArray2[n];
        }
        byArray2 = ID3Tag.getPaddedByteArray(this.getYear(), 4);
        for (n = 0; n < 4; ++n) {
            byArray[n + 93] = byArray2[n];
        }
        byArray2 = ID3Tag.getPaddedByteArray(this.getComment(), 29);
        for (n = 0; n < 29; ++n) {
            byArray[n + 97] = byArray2[n];
        }
        byArray[126] = this.getTrack();
        byArray[127] = this.getGenre();
        return byArray;
    }
}

