/*
 * Decompiled with CFR 0.152.
 */
package de.ueberdosis.mp3info;

import de.ueberdosis.mp3info.ID3Tag;
import de.ueberdosis.mp3info.id3v2.ID3V2Tag;
import de.ueberdosis.util.OutputCtr;

public class ExtendedID3Tag
extends ID3Tag {
    private int mpegID;
    private int layer;
    private int bitrate;
    private int bitrate2 = 0;
    private boolean crc;
    private int freq;
    private boolean padded;
    private int chanMode = 4;
    private boolean copyright;
    private boolean original;
    private int emphasis = 4;
    private long size = 0L;
    private long position = 0L;
    private long runtime = 0L;
    private int frameCount = 0;
    private long iD3v2Size = 0L;
    private ID3V2Tag v2tag = null;
    public static final String[][] bitrates = new String[][]{{"free", "free", "free", "free", "free"}, {"32", "32", "32", "32", "8"}, {"64", "48", "40", "48", "16"}, {"96", "56", "48", "56", "24"}, {"128", "64", "56", "64", "32"}, {"160", "80", "64", "80", "40"}, {"192", "96", "80", "96", "48"}, {"224", "112", "96", "112", "56"}, {"256", "128", "112", "128", "64"}, {"288", "160", "128", "144", "80"}, {"320", "192", "160", "160", "96"}, {"352", "224", "192", "176", "112"}, {"384", "256", "224", "192", "128"}, {"416", "320", "256", "224", "144"}, {"448", "384", "320", "256", "160"}, {"bad", "bad", "bad", "bad", "bad"}};
    public static final int[][] bitratesI = new int[][]{{-1, -1, -1, -1, -1}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-2, -2, -2, -2, -2}};
    public static final String[][] frequencies = new String[][]{{"44100", "22050", "11025"}, {"48000", "24000", "12000"}, {"32000", "16000", "8000"}, {"reserved", "reserved", "reserved"}};
    public static final int[][] frequenciesI = new int[][]{{44100, 22050, 11025}, {48000, 24000, 12000}, {32000, 16000, 8000}, {-1, -1, -1}};
    public static final String[] channelModes = new String[]{"Stereo", "Joint Stereo (Stereo)", "Dual Channel (Stereo)", "Single Channel (Mono)", "bad"};
    public static final int[] channels = new int[]{2, 2, 2, 1, 0};
    public static final String[] emps = new String[]{"none", "50/15ms", "reserved", "CCIT J.17", "bad"};

    public ExtendedID3Tag(ID3Tag iD3Tag) {
        super(iD3Tag);
    }

    ExtendedID3Tag() {
    }

    public void setMpegID(int n) {
        this.mpegID = n;
    }

    public int getMpegID() {
        return this.mpegID;
    }

    public String getMpegIDS() {
        String string = "error";
        switch (this.getMpegID()) {
            case 0: {
                string = "2.5";
                break;
            }
            case 2: {
                string = "2";
                break;
            }
            case 3: {
                string = "1";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public int getLayer() {
        return this.layer;
    }

    public String getLayerS() {
        String string = "error";
        switch (this.getLayer()) {
            case 0: {
                string = "reserved";
                break;
            }
            case 1: {
                string = "III";
                break;
            }
            case 2: {
                string = "II";
                break;
            }
            case 3: {
                string = "I";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public int getLayerI() {
        int n = 0;
        switch (this.getLayer()) {
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public void setBitrate(int n) {
        this.bitrate = n;
    }

    public void setBitrate2(int n) {
        this.bitrate2 = n;
    }

    public String getBitrateS() {
        String string = "error";
        if (this.bitrate < bitrates.length) {
            if (this.getMpegID() == 3 && this.getLayer() == 3) {
                string = bitrates[this.bitrate][0];
            } else if (this.getMpegID() == 3 && this.getLayer() == 2) {
                string = bitrates[this.bitrate][1];
            } else if (this.getMpegID() == 3 && this.getLayer() == 1) {
                string = bitrates[this.bitrate][2];
            } else if (this.getMpegID() == 2 && this.getLayer() == 3) {
                string = bitrates[this.bitrate][3];
            } else if (this.getMpegID() == 2) {
                string = bitrates[this.bitrate][4];
            }
        }
        return string;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getBitrateI() {
        int n = 0;
        if (this.bitrate < bitratesI.length) {
            if (this.getMpegID() == 3 && this.getLayer() == 3) {
                n = bitratesI[this.bitrate][0];
            } else if (this.getMpegID() == 3 && this.getLayer() == 2) {
                n = bitratesI[this.bitrate][1];
            } else if (this.getMpegID() == 3 && this.getLayer() == 1) {
                n = bitratesI[this.bitrate][2];
            } else if (this.getMpegID() == 2 && this.getLayer() == 3) {
                n = bitratesI[this.bitrate][3];
            } else if (this.getMpegID() == 2) {
                n = bitratesI[this.bitrate][4];
            }
        }
        return n;
    }

    public int getBitrate2I() {
        int n = 0;
        if (this.bitrate2 < bitrates.length) {
            if (this.getMpegID() == 3 && this.getLayer() == 3) {
                n = bitratesI[this.bitrate2][0];
            } else if (this.getMpegID() == 3 && this.getLayer() == 2) {
                n = bitratesI[this.bitrate2][1];
            } else if (this.getMpegID() == 3 && this.getLayer() == 1) {
                n = bitratesI[this.bitrate2][2];
            } else if (this.getMpegID() == 2 && this.getLayer() == 3) {
                n = bitratesI[this.bitrate2][3];
            } else if (this.getMpegID() == 2) {
                n = bitratesI[this.bitrate2][4];
            }
        }
        return n;
    }

    public String getBitrate2S() {
        String string = "error";
        if (this.bitrate2 < bitrates.length) {
            if (this.getMpegID() == 3 && this.getLayer() == 3) {
                string = bitrates[this.bitrate2][0];
            } else if (this.getMpegID() == 3 && this.getLayer() == 2) {
                string = bitrates[this.bitrate2][1];
            } else if (this.getMpegID() == 3 && this.getLayer() == 1) {
                string = bitrates[this.bitrate2][2];
            } else if (this.getMpegID() == 2 && this.getLayer() == 3) {
                string = bitrates[this.bitrate2][3];
            } else if (this.getMpegID() == 2) {
                string = bitrates[this.bitrate2][4];
            }
        }
        return string;
    }

    public void setCrc(boolean bl) {
        this.crc = bl;
    }

    public boolean getCrc() {
        return this.crc;
    }

    public void setFrequency(int n) {
        this.freq = n;
    }

    public int getFrequency() {
        return this.freq;
    }

    public String getFrequencyS() {
        String string = "error";
        if (this.freq < frequencies.length) {
            switch (this.getMpegID()) {
                case 3: {
                    string = frequencies[this.freq][0];
                    break;
                }
                case 2: {
                    string = frequencies[this.freq][1];
                    break;
                }
                case 0: {
                    string = frequencies[this.freq][2];
                }
            }
        }
        return string;
    }

    public int getFrequencyI() {
        int n = 0;
        if (this.freq < frequencies.length) {
            switch (this.getMpegID()) {
                case 3: {
                    n = frequenciesI[this.freq][0];
                    break;
                }
                case 2: {
                    n = frequenciesI[this.freq][1];
                    break;
                }
                case 0: {
                    n = frequenciesI[this.freq][2];
                }
            }
        }
        return n;
    }

    public void setPadding(boolean bl) {
        this.padded = bl;
    }

    public boolean getPadding() {
        return this.padded;
    }

    public void setChannelMode(int n) {
        this.chanMode = n >= 0 && n < 4 ? n : 4;
    }

    public int getChannelMode() {
        return this.chanMode;
    }

    public String getChannelModeS() {
        return channelModes[this.chanMode];
    }

    public void setCopyright(boolean bl) {
        this.copyright = bl;
    }

    public boolean getCopyright() {
        return this.copyright;
    }

    public void setOriginal(boolean bl) {
        this.original = bl;
    }

    public boolean getOriginal() {
        return this.original;
    }

    public void setEmphasis(int n) {
        this.emphasis = n >= 0 && n < 4 ? n : 4;
    }

    public int getEmphasis() {
        return this.emphasis;
    }

    public String getEmphasisS() {
        return emps[this.emphasis];
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public void setRuntime(int n) {
        if (n > 0) {
            OutputCtr.println(0, "Somebody set the runtime directly.\nThis is deprecated!");
            this.runtime = n * 1000;
        } else {
            this.runtime = 0L;
        }
    }

    public void setKRuntime(long l) {
        this.runtime = l;
    }

    public int getRuntime() {
        if (this.runtime == 0L) {
            int n = this.getBitrateI();
            if (n != 0) {
                return (int)((double)this.getSize() / ((double)this.getBitrateI() * 1000.0 / 8.0));
            }
            return 0;
        }
        return (int)(this.runtime / 1000L);
    }

    public void setFramecount(int n) {
        this.frameCount = n;
    }

    public int getFramecount() {
        return this.frameCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isValidTag()) {
            stringBuffer.append("This file has no tag.\n");
        }
        stringBuffer.append("Title   : ").append(this.getTitle()).append("\nArtist  : ").append(this.getArtist()).append("\nAlbum   : ").append(this.getAlbum()).append("\nYear    : ").append(this.getYear()).append("\nComment : ").append(this.getComment()).append("\nGenre   : ").append(genres[this.getGenre()]).append("\nTrack   : ").append(this.getTrack()).append("\nMpeg ").append(this.getMpegIDS()).append(" Layer ").append(this.getLayerS()).append("\nBitrate : ").append(this.getBitrateS()).append(" kbps\nBitrate2: ").append(this.getBitrate2S()).append(" kbps\nSampling-Rate: ").append(this.getFrequencyS()).append("\nCRC-Protection: ");
        if (this.crc) {
            stringBuffer.append("on");
        } else {
            stringBuffer.append("off");
        }
        stringBuffer.append("\nChannel-Mode: ").append(this.getChannelModeS()).append("\nCopyrighted : ");
        if (this.getCopyright()) {
            stringBuffer.append("on");
        } else {
            stringBuffer.append("off");
        }
        stringBuffer.append("\nOriginal : ");
        if (this.getOriginal()) {
            stringBuffer.append("on");
        } else {
            stringBuffer.append("off");
        }
        stringBuffer.append("\nEmphasis: ").append(this.getEmphasisS());
        if (this.runtime == 0L) {
            stringBuffer.append("\nGuessed playing time: ");
        } else {
            stringBuffer.append("\nPlaying time: ");
        }
        stringBuffer.append(this.getRuntime()).append(" seconds.");
        if (this.frameCount != 0) {
            stringBuffer.append("\nFramecount: ").append(this.getFramecount());
        }
        return stringBuffer.toString();
    }

    public String getTechnicalString() {
        StringBuffer stringBuffer = new StringBuffer().append("\nMpeg ").append(this.getMpegIDS()).append(" Layer ").append(this.getLayerS()).append(" BR: ").append(this.getBitrateS()).append(" kbps SR: ").append(this.getFrequencyS()).append(" CRC: ");
        if (this.crc) {
            stringBuffer.append("on");
        } else {
            stringBuffer.append("off");
        }
        stringBuffer.append(" ChMo: ").append(this.getChannelModeS()).append(" cpr: ");
        if (this.getCopyright()) {
            stringBuffer.append("on");
        } else {
            stringBuffer.append("off");
        }
        stringBuffer.append(" Orig: ");
        if (this.getOriginal()) {
            stringBuffer.append("on");
        } else {
            stringBuffer.append("off");
        }
        stringBuffer.append(" Emp: ").append(this.getEmphasisS());
        return stringBuffer.toString();
    }

    void setPosition(long l) {
        this.position = l;
    }

    long getPosition() {
        return this.position;
    }

    void setID3v2Size(long l) {
        if (l >= 0L) {
            this.iD3v2Size = l;
        }
    }

    long getID3v2Size() {
        return this.iD3v2Size;
    }

    void setID3V2Tag(ID3V2Tag iD3V2Tag) {
        this.v2tag = iD3V2Tag;
    }

    public ID3V2Tag getV2Tag() {
        return this.v2tag;
    }

    public void updateBitrates(ExtendedID3Tag extendedID3Tag) {
        int n = this.getBitrateI();
        int n2 = this.getBitrate2I();
        int n3 = extendedID3Tag.getBitrateI();
        int n4 = 0;
        if (n3 > n) {
            if (n < n2 || n2 <= 0) {
                n4 = this.findBr(n2);
                this.bitrate2 = n4 == -1 ? this.bitrate2 : n4;
            }
            this.bitrate = (n4 = this.findBr(n3)) == -1 ? this.bitrate2 : n4;
        } else if (n3 < n2 || n2 <= 0) {
            n4 = this.findBr(n3);
            this.bitrate2 = n4 == -1 ? this.bitrate2 : n4;
        }
    }

    private int findBr(int n) {
        int n2 = 0;
        int n3 = -1;
        if (this.getMpegID() == 3 && this.getLayer() == 3) {
            n2 = 0;
        } else if (this.getMpegID() == 3 && this.getLayer() == 2) {
            n2 = 1;
        } else if (this.getMpegID() == 3 && this.getLayer() == 1) {
            n2 = 2;
        } else if (this.getMpegID() == 2 && this.getLayer() == 3) {
            n2 = 3;
        } else if (this.getMpegID() == 2) {
            n2 = 4;
        }
        for (int i = 0; i < bitratesI.length && n3 == -1; ++i) {
            if (bitratesI[i][n2] != n) continue;
            n3 = i;
        }
        return n3;
    }
}

