/*
 * Decompiled with CFR 0.152.
 */
package helma.main.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;

public class Main {
    public static final String[] jars = new String[]{"helma.jar", "rhino.jar", "jetty.jar", "commons-logging.jar", "crimson.jar", "xmlrpc.jar", "servlet.jar", "mail.jar", "activation.jar", "commons-fileupload.jar", "commons-codec.jar", "commons-io.jar", "netcomponents.jar", "tagsoup.jar"};

    public static void main(String[] args) {
        try {
            String installDir = Main.getInstallDir(args);
            ClassLoader loader = Main.createClassLoader(installDir);
            Class<?> clazz = loader.loadClass("helma.main.Server");
            Class[] cargs = new Class[]{args.getClass()};
            Method main = clazz.getMethod("main", cargs);
            Object[] nargs = new Object[]{args};
            main.invoke(null, nargs);
        }
        catch (Exception x) {
            System.err.println("Unable to get Helma installation directory: ");
            x.printStackTrace();
            System.exit(2);
        }
    }

    public static ClassLoader createClassLoader(String installDir) throws MalformedURLException {
        installDir = URLDecoder.decode(installDir);
        File libdir = new File(installDir, "lib");
        ArrayList<URL> jarlist = new ArrayList<URL>();
        for (int i = 0; i < jars.length; ++i) {
            File jar = new File(libdir, jars[i]);
            jarlist.add(new URL("file:" + jar.getAbsolutePath()));
        }
        File extdir = new File(libdir, "ext");
        File[] files = extdir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String n = name.toLowerCase();
                return n.endsWith(".jar") || n.endsWith(".zip");
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                jarlist.add(new URL("file:" + files[i].getAbsolutePath()));
                System.err.println("Adding to classpath: " + files[i].getAbsolutePath());
            }
        }
        URL[] urls = new URL[jarlist.size()];
        jarlist.toArray(urls);
        String excludeSystemClasses = System.getProperty("helma.excludeSystemClasses");
        URLClassLoader loader = "true".equalsIgnoreCase(excludeSystemClasses) ? new URLClassLoader(urls, null) : new URLClassLoader(urls);
        Thread.currentThread().setContextClassLoader(loader);
        return loader;
    }

    public static String getInstallDir(String[] args) throws IOException, MalformedURLException {
        String installDir = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-i") || i + 1 >= args.length) continue;
            installDir = args[i + 1];
        }
        URLClassLoader apploader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        if (installDir == null) {
            URL launcherUrl = apploader.findResource("helma/main/launcher/Main.class");
            String jarUrl = launcherUrl.toString();
            if (!jarUrl.startsWith("jar:") || jarUrl.indexOf("!") < 0) {
                installDir = System.getProperty("user.dir");
                System.err.println("Warning: Helma install dir not set by -i parameter ");
                System.err.println("         and not started from launcher.jar. Using ");
                System.err.println("         current working directory as install dir.");
            } else {
                jarUrl = jarUrl.substring(4);
                int excl = jarUrl.indexOf("!");
                jarUrl = jarUrl.substring(0, excl);
                launcherUrl = new URL(jarUrl);
                File f = new File(launcherUrl.getPath()).getAbsoluteFile();
                installDir = f.getParentFile().getCanonicalPath();
            }
        }
        System.setProperty("helma.home", installDir);
        return installDir;
    }
}

