/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.net.dns;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.wonderly.net.dns.RR;

public class WKSRR
extends RR {
    String host;
    String addr;
    int recs = 1;
    int dlen;
    int proto;
    Vector ports;

    public String toString() {
        return String.valueOf(this.host) + "\t\t" + super.toString() + "\t" + this.addr + ", proto=" + this.proto + ", ports=" + this.ports;
    }

    public WKSRR(byte[] pkt, int cidx) {
        super(pkt, cidx, 11);
    }

    public String getHost() {
        return this.host;
    }

    public InetAddress getHostAddress() throws IOException {
        return InetAddress.getByName(this.addr);
    }

    public int getRecordCount() {
        return this.recs;
    }

    public int dataLength() {
        return this.dlen;
    }

    public Enumeration getPortsList() {
        return this.ports.elements();
    }

    public void processRecord(int cidx) {
        this.ports = new Vector(10);
        StringBuffer buf = new StringBuffer();
        int nmlen = cidx;
        int fidx = cidx;
        cidx = RR.extractName(this.rdata, cidx, this.rdata.length, buf);
        this.host = buf.toString();
        nmlen = cidx - nmlen;
        cidx = this.setParameters(this.rdata, cidx);
        byte b1 = this.rdata[cidx++];
        byte b2 = this.rdata[cidx++];
        byte b3 = this.rdata[cidx++];
        byte b4 = this.rdata[cidx++];
        this.addr = String.valueOf(b1 & 0xFF) + "." + (b2 & 0xFF) + "." + (b3 & 0xFF) + "." + (b4 & 0xFF);
        this.proto = this.rdata[cidx++] & 0xFF;
        int cnt = this.rdlength - 5;
        int i = 0;
        while (i < cnt) {
            int v = this.rdata[i + cidx] & 0xFF;
            int j = 7;
            while (j >= 0) {
                int bit = i * 8 + (7 - j);
                if ((v & 1 << j) != 0) {
                    this.ports.addElement(new Integer(bit));
                }
                --j;
            }
            ++i;
        }
        this.dlen = cidx - fidx + cnt;
    }
}

