/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.net.dns;

import org.wonderly.net.dns.Question;
import org.wonderly.net.dns.RR;

public class SOARR
extends RR {
    String rname;
    String mname;
    String dname;
    int recs = 1;
    int dlen;
    int serial;
    int refresh;
    int retry;
    int expire;
    int minimum;

    public String toString() {
        return String.valueOf(this.dname) + "\t\t" + super.toString() + "\t" + this.mname + ", " + this.rname + "\n" + "\tSERIAL " + this.serial + "\n" + "\tREFRESH " + Question.toTime(this.refresh) + "\n" + "\tRETRY " + Question.toTime(this.retry) + "\n" + "\tEXPIRE " + Question.toTime(this.expire) + "\n" + "\tMINIMUM " + Question.toTime(this.minimum);
    }

    public SOARR(byte[] pkt, int cidx) {
        super(pkt, cidx, 6);
    }

    public String getNSHost() {
        return this.mname;
    }

    public String getResponsibleEmail() {
        return this.rname;
    }

    public int getRecordCount() {
        return this.recs;
    }

    public int dataLength() {
        return this.dlen;
    }

    public void processRecord(int cidx) {
        StringBuffer buf = new StringBuffer();
        int fidx = cidx;
        cidx = RR.extractName(this.rdata, cidx, this.rdata.length, buf);
        this.dname = buf.toString();
        cidx = this.setParameters(this.rdata, cidx);
        buf.setLength(0);
        cidx = RR.extractName(this.rdata, cidx, this.rdata.length, buf);
        this.mname = buf.toString();
        buf.setLength(0);
        cidx = RR.extractName(this.rdata, cidx, this.rdata.length, buf);
        this.rname = buf.toString();
        this.serial = (this.rdata[cidx] & 0xFF) << 24 | (this.rdata[cidx + 1] & 0xFF) << 16 | (this.rdata[cidx + 2] & 0xFF) << 8 | this.rdata[cidx + 3] & 0xFF;
        this.refresh = (this.rdata[cidx += 4] & 0xFF) << 24 | (this.rdata[cidx + 1] & 0xFF) << 16 | (this.rdata[cidx + 2] & 0xFF) << 8 | this.rdata[cidx + 3] & 0xFF;
        this.retry = (this.rdata[cidx += 4] & 0xFF) << 24 | (this.rdata[cidx + 1] & 0xFF) << 16 | (this.rdata[cidx + 2] & 0xFF) << 8 | this.rdata[cidx + 3] & 0xFF;
        this.expire = (this.rdata[cidx += 4] & 0xFF) << 24 | (this.rdata[cidx + 1] & 0xFF) << 16 | (this.rdata[cidx + 2] & 0xFF) << 8 | this.rdata[cidx + 3] & 0xFF;
        this.minimum = (this.rdata[cidx += 4] & 0xFF) << 24 | (this.rdata[cidx + 1] & 0xFF) << 16 | (this.rdata[cidx + 2] & 0xFF) << 8 | this.rdata[cidx + 3] & 0xFF;
        this.dlen = (cidx += 4) - fidx;
    }
}

