/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.net.dns;

import java.util.StringTokenizer;
import org.wonderly.net.dns.Question;

public abstract class RR {
    protected String name;
    protected int type;
    protected int rclass;
    protected int ttl;
    protected int rdlength;
    protected byte[] rdata;
    protected int off;
    protected static boolean debug;

    public static void setDebug(boolean how) {
        debug = how;
    }

    public String toString() {
        return String.valueOf(debug ? "@" + this.off + " " : "") + Question.toTime(this.ttl) + "\t\t" + Question.toClass(this.rclass) + "\t" + Question.toType(this.type);
    }

    public static int getRRType(byte[] pkt, int off) {
        int idx = RR.extractName(pkt, off, pkt.length, null);
        if (debug) {
            System.out.println("extract type at idx: " + idx);
        }
        return (pkt[idx] & 0xFF) << 8 | pkt[idx + 1] & 0xFF;
    }

    public static int getRRClass(byte[] pkt, int off) {
        int idx = RR.extractName(pkt, off, pkt.length, null);
        if (debug) {
            System.out.println("extract class at idx: " + idx);
        }
        return (pkt[idx + 2] & 0xFF) << 8 | pkt[idx + 3] & 0xFF;
    }

    public static int getRRttl(byte[] pkt, int off) {
        int idx = RR.extractName(pkt, off, pkt.length, null);
        if (debug) {
            System.out.println("extract ttl at idx: " + idx);
        }
        return (pkt[idx + 4] & 0xFF) << 24 | (pkt[idx + 5] & 0xFF) << 16 | (pkt[idx + 6] & 0xFF) << 8 | pkt[idx + 7] & 0xFF;
    }

    public static int getRRdlen(byte[] pkt, int off) {
        int idx = RR.extractName(pkt, off, pkt.length, null);
        if (debug) {
            System.out.println("extract dlen at idx: " + idx);
        }
        return (pkt[idx + 8] & 0xFF) << 8 | pkt[idx + 9] & 0xFF;
    }

    public static int extractName(byte[] data, int start, int len, StringBuffer name) {
        int idx = start;
        int tlen = 0;
        if (debug) {
            System.out.println("extract name (" + name + ") at idx: " + idx + ", data.length: " + data.length);
        }
        while (data[idx] != 0 && start < len) {
            if (name != null && name.length() > 0) {
                name.append('.');
            }
            ++tlen;
            if (debug) {
                System.out.println("Found at: " + idx + ": 0x" + Long.toHexString(data[idx] & 0xFF));
            }
            if ((data[idx] & 0xC0) == 0) {
                if (name != null) {
                    if (debug) {
                        System.out.println("in line label: @" + idx + ": " + new String(data, idx + 1, (int)data[idx]));
                    }
                    name.append(new String(data, idx + 1, (int)data[idx]));
                }
                idx += (data[idx] & 0xFF) + 1;
                tlen += data[idx] & 0xFF;
            } else {
                if ((data[idx] & 0xC0) == 192) {
                    int off = (data[idx + 1] & 0xFF) + ((data[idx] & 0x3F) << 8);
                    StringBuffer buf = new StringBuffer();
                    int toff = RR.extractName(data, off, len, buf);
                    if (name != null) {
                        if (debug) {
                            System.out.println("Ref'd label (have=" + name + "): @" + off + ": got: " + buf);
                        }
                        name.append(buf.toString());
                    }
                    tlen += buf.toString().length();
                    ++idx;
                    break;
                }
                throw new IllegalArgumentException("Unrecognized length format @" + idx + ": (" + (data[idx] & 0xFF) + ") 0x" + Long.toHexString(data[idx]));
            }
            if (!debug) continue;
            System.out.println("next (0x" + Long.toHexString(data[idx] & 0xFF) + "), idx: " + idx + ", data.length: " + data.length);
        }
        return idx + 1;
    }

    public static int nameLength(String name) {
        return name.length() + 2;
    }

    protected int setParameters(byte[] pkt, int idx) {
        this.type = (pkt[idx] & 0xFF) << 8 | pkt[idx + 1] & 0xFF;
        this.rclass = (pkt[idx += 2] & 0xFF) << 8 | pkt[idx + 1] & 0xFF;
        this.ttl = (pkt[idx += 2] & 0xFF) << 24 | (pkt[idx + 1] & 0xFF) << 16 | (pkt[idx + 2] & 0xFF) << 8 | pkt[idx + 3] & 0xFF;
        this.rdlength = (pkt[idx += 4] & 0xFF) << 8 | pkt[idx + 1] & 0xFF;
        return idx += 2;
    }

    public static int copyInName(byte[] data, int start, String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        int idx = 0;
        while (st.hasMoreTokens()) {
            String c = st.nextToken();
            if (c.length() > 63) {
                c = c.substring(0, 63);
            }
            data[idx++] = (byte)c.length();
            int i = 0;
            while (i < c.length()) {
                data[idx++] = (byte)c.charAt(i);
                ++i;
            }
        }
        data[idx] = 0;
        return idx + 1;
    }

    public RR(byte[] pkt, int rroff, int type) {
        this.rdata = pkt;
        this.type = type;
        StringBuffer name = new StringBuffer();
        this.off = rroff;
        int idx = RR.extractName(pkt, 0, pkt.length, name);
        this.name = name.toString();
        idx = this.setParameters(pkt, idx);
        this.processRecord(rroff);
    }

    public int getType() {
        return this.type;
    }

    public abstract void processRecord(int var1);

    public abstract int dataLength();
}

