/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.net.dns;

import org.wonderly.net.dns.RR;

public class Question {
    protected byte[] data;
    protected int len;
    protected String name;
    protected int qtype;
    protected int qclass;
    public static final int CLASS_IN = 1;
    public static final int TYPE_A = 1;
    public static final int TYPE_NS = 2;
    public static final int TYPE_MD = 3;
    public static final int TYPE_MF = 4;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_SOA = 6;
    public static final int TYPE_MB = 7;
    public static final int TYPE_MG = 8;
    public static final int TYPE_MR = 9;
    public static final int TYPE_NULL = 10;
    public static final int TYPE_WKS = 11;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_HINFO = 13;
    public static final int TYPE_MINFO = 14;
    public static final int TYPE_MX = 15;
    public static final int TYPE_TXT = 16;

    public static String toTime(int ttl) {
        String buf = "";
        while (ttl > 0) {
            int v = 0;
            if (ttl < 60) {
                buf = String.valueOf(buf) + ttl + "s";
                ttl = 0;
                continue;
            }
            if (ttl < 3600) {
                v = ttl / 60;
                buf = String.valueOf(buf) + v + "m";
                ttl %= 60;
                continue;
            }
            if (ttl < 86400) {
                v = ttl / 3600;
                buf = String.valueOf(buf) + v + "h";
                ttl %= 3600;
                continue;
            }
            if (ttl < 604800) {
                v = ttl / 86400;
                buf = String.valueOf(buf) + v + "d";
                ttl %= 86400;
                continue;
            }
            v = ttl / 604800;
            buf = String.valueOf(buf) + v + "w";
            ttl %= 604800;
        }
        return buf;
    }

    public String toString() {
        return String.valueOf(Question.toType(this.qtype)) + "[" + Question.toClass(this.qclass) + "] for " + this.name;
    }

    public static String toClass(int cls) {
        String buf = "" + cls;
        if (cls == 1) {
            buf = "IN";
        }
        return buf;
    }

    public static String toType(int type) {
        String buf = "" + type;
        switch (type) {
            case 1: {
                buf = "A";
                break;
            }
            case 2: {
                buf = "NS";
                break;
            }
            case 3: {
                buf = "MD";
                break;
            }
            case 4: {
                buf = "MF";
                break;
            }
            case 5: {
                buf = "CNAME";
                break;
            }
            case 6: {
                buf = "SOA";
                break;
            }
            case 7: {
                buf = "MB";
                break;
            }
            case 8: {
                buf = "MG";
                break;
            }
            case 9: {
                buf = "MR";
                break;
            }
            case 10: {
                buf = "NULL";
                break;
            }
            case 11: {
                buf = "WKS";
                break;
            }
            case 12: {
                buf = "PTR";
                break;
            }
            case 13: {
                buf = "HINFO";
                break;
            }
            case 14: {
                buf = "MINFO";
                break;
            }
            case 15: {
                buf = "MX";
                break;
            }
            case 16: {
                buf = "TXT";
            }
        }
        return buf;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.qtype = type;
    }

    public void setClass(int cls) {
        this.qclass = cls;
    }

    public Question(String name, int qtype, int qclass) {
        int nlen = RR.nameLength(name);
        this.name = name;
        this.qtype = qtype;
        this.qclass = qclass;
        this.data = new byte[nlen + 4];
        RR.copyInName(this.data, 0, name);
        this.data[nlen] = (byte)(qtype >> 8);
        this.data[nlen + 1] = (byte)(qtype & 0xFF);
        this.data[nlen + 2] = (byte)(qclass >> 8);
        this.data[nlen + 3] = (byte)(qclass & 0xFF);
        this.len = nlen + 4;
    }

    public int length() {
        return this.len;
    }

    public byte[] getData() {
        return this.data;
    }
}

