/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.net.dns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import org.wonderly.net.dns.ARR;
import org.wonderly.net.dns.CNAMERR;
import org.wonderly.net.dns.HINFORR;
import org.wonderly.net.dns.MBRR;
import org.wonderly.net.dns.MDRR;
import org.wonderly.net.dns.MFRR;
import org.wonderly.net.dns.MGRR;
import org.wonderly.net.dns.MINFORR;
import org.wonderly.net.dns.MRRR;
import org.wonderly.net.dns.MXRR;
import org.wonderly.net.dns.NSRR;
import org.wonderly.net.dns.NULLRR;
import org.wonderly.net.dns.PTRRR;
import org.wonderly.net.dns.Question;
import org.wonderly.net.dns.RR;
import org.wonderly.net.dns.SOARR;
import org.wonderly.net.dns.TXTRR;
import org.wonderly.net.dns.WKSRR;

public class Query {
    private static int queryno = 0;
    private byte[] data;
    private byte[] qdata;
    private int opcode = 1;
    private Vector l = new Vector();
    private Vector answers;
    private Vector nsAnswers;
    private Vector extraAnswers;
    private static boolean debug;

    public static void setDebug(boolean how) {
        debug = how;
    }

    public static void main(String[] args) throws Exception {
        String nss = "localhost";
        if (args.length > 0) {
            nss = args[0];
        } else {
            System.err.println("Provide DNS address as argument");
            System.exit(1);
        }
        Question mx = new Question("hotmail.com", 15, 1);
        Query tst = new Query(mx);
        tst.runQuery("ns1.apa.net");
        RR[] result = tst.getAnswers();
        int i = 0;
        while (i < result.length) {
            RR curr = result[i];
            if (curr.type == 15) {
                System.out.println(curr.toString());
            }
            ++i;
        }
    }

    public static void printQuery(Question quest, String queryNs) throws IOException {
        Query q = new Query(new Question[]{quest});
        if (debug) {
            System.out.println("\nRunning Query/Question: " + quest + "\n");
        }
        q.runQuery(queryNs);
        RR[] ans = q.getAnswers();
        System.out.println("answers: " + ans.length);
        int i = 0;
        while (i < ans.length) {
            System.out.println(ans[i]);
            ++i;
        }
        RR[] nsans = q.getNameServerAnswers();
        System.out.println("ns answers: " + nsans.length);
        int i2 = 0;
        while (i2 < nsans.length) {
            System.out.println(nsans[i2]);
            ++i2;
        }
        RR[] exans = q.getAdditionalAnswers();
        System.out.println("extra data answers: " + exans.length);
        int i3 = 0;
        while (i3 < exans.length) {
            System.out.println(exans[i3]);
            ++i3;
        }
    }

    public RR[] getAnswers() {
        Object[] rr = new RR[this.answers.size()];
        this.answers.copyInto(rr);
        return rr;
    }

    public RR[] getNameServerAnswers() {
        Object[] rr = new RR[this.nsAnswers.size()];
        this.nsAnswers.copyInto(rr);
        return rr;
    }

    public RR[] getAdditionalAnswers() {
        Object[] rr = new RR[this.extraAnswers.size()];
        this.extraAnswers.copyInto(rr);
        return rr;
    }

    public void runQuery() throws IOException {
        this.runQuery(InetAddress.getLocalHost().getHostAddress());
    }

    public void runQuery(String ns) throws IOException {
        RR rr;
        int len;
        Socket s = new Socket(ns, 53);
        OutputStream os = s.getOutputStream();
        byte[] b = this.getQueryData();
        if (debug) {
            int i = 0;
            while (i < b.length) {
                System.out.print(" ");
                System.out.print("[" + i + "]" + (b[i] >= 32 && b[i] <= 127 ? "(" + (char)b[i] + ")" : "(?)0x") + Long.toHexString(b[i] & 0xFF));
                if ((i + 1) % 2 == 0) {
                    System.out.println("");
                }
                ++i;
            }
        }
        int wlen = len = b.length;
        if (debug) {
            System.out.println("\nwriting " + len + " bytes");
        }
        os.write(b.length >> 8);
        os.write(b.length & 0xFF);
        os.write(b);
        os.flush();
        InputStream is = s.getInputStream();
        if (debug) {
            System.out.print("reading response ");
        }
        len = is.read() << 8 & 0xFF00;
        this.data = new byte[len |= is.read()];
        int off = 0;
        int rlen = 0;
        while ((rlen += is.read(this.data, off, len - off)) < len) {
        }
        if (debug) {
            System.out.println("return len: " + len);
        }
        s.close();
        int rcnt = this.data[6] << 8 & 0xFF | this.data[7] & 0xFF;
        int nscnt = this.data[8] << 8 & 0xFF | this.data[9] & 0xFF;
        int arcnt = this.data[10] << 8 & 0xFF | this.data[11] & 0xFF;
        b = this.data;
        if (debug) {
            int i = 0;
            while (i < b.length) {
                System.out.print(" ");
                System.out.print("[" + i + "]" + (b[i] >= 32 && b[i] <= 127 ? "(" + (char)b[i] + ")" : "(?)0x") + Long.toHexString(b[i] & 0xFF));
                if ((i + 1) % 2 == 0) {
                    System.out.println("");
                }
                ++i;
            }
            System.out.println("");
        }
        this.answers = new Vector(rcnt);
        int cidx = wlen;
        int i = 0;
        while (i < rcnt) {
            int rtype = RR.getRRType(this.data, cidx);
            RR rr2 = this.processRR(rtype, this.data, cidx);
            cidx += rr2.dataLength();
            this.answers.addElement(rr2);
            ++i;
        }
        this.nsAnswers = new Vector(nscnt);
        i = 0;
        while (i < nscnt) {
            StringBuffer buf = new StringBuffer();
            int rtype = RR.getRRType(this.data, cidx);
            rr = this.processRR(rtype, this.data, cidx);
            cidx += rr.dataLength();
            this.nsAnswers.addElement(rr);
            ++i;
        }
        this.extraAnswers = new Vector(arcnt);
        i = 0;
        while (i < arcnt) {
            StringBuffer buf = new StringBuffer();
            int rtype = RR.getRRType(this.data, cidx);
            rr = this.processRR(rtype, this.data, cidx);
            cidx += rr.dataLength();
            this.extraAnswers.addElement(rr);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected RR processRR(int rtype, byte[] data, int cidx) throws IOException {
        void var4_4;
        RR rr;
        if (rtype == 1) {
            rr = new ARR(data, cidx);
        } else if (rtype == 2) {
            rr = new NSRR(data, cidx);
        } else if (rtype == 12) {
            rr = new PTRRR(data, cidx);
        } else if (rtype == 15) {
            rr = new MXRR(data, cidx);
        } else if (rtype == 8) {
            rr = new MGRR(data, cidx);
        } else if (rtype == 16) {
            rr = new TXTRR(data, cidx);
        } else if (rtype == 14) {
            rr = new MINFORR(data, cidx);
        } else if (rtype == 13) {
            rr = new HINFORR(data, cidx);
        } else if (rtype == 9) {
            rr = new MRRR(data, cidx);
        } else if (rtype == 11) {
            rr = new WKSRR(data, cidx);
        } else if (rtype == 7) {
            rr = new MBRR(data, cidx);
        } else if (rtype == 3) {
            rr = new MDRR(data, cidx);
        } else if (rtype == 4) {
            rr = new MFRR(data, cidx);
        } else if (rtype == 10) {
            rr = new NULLRR(data, cidx);
        } else if (rtype == 6) {
            rr = new SOARR(data, cidx);
        } else if (rtype == 5) {
            rr = new CNAMERR(data, cidx);
        } else {
            throw new IOException("unsupported answer, type=" + Question.toType(rtype));
        }
        return var4_4;
    }

    public Query(Question req) {
        this.setQuestion(req);
    }

    public void setQuestion(Question req) {
        int idx;
        this.opcode = 0;
        int len = idx = 12;
        this.qdata = new byte[len += req.length()];
        this.qdata[0] = (byte)(queryno >> 8);
        this.qdata[1] = (byte)(queryno & 0xFF);
        int val = 0x100 | this.opcode << 11;
        this.qdata[2] = (byte)(val >> 8);
        this.qdata[3] = (byte)(val & 0xFF);
        this.qdata[4] = 0;
        this.qdata[5] = 1;
        System.arraycopy(req.getData(), 0, this.qdata, idx, req.length());
    }

    public Query(Question[] req) {
        this.setQuestions(req);
    }

    public void setQuestions(Question[] req) {
        this.opcode = 0;
        int len = 12;
        int i = 0;
        while (i < req.length) {
            len += req[i].length();
            ++i;
        }
        this.qdata = new byte[len];
        this.qdata[0] = (byte)(queryno >> 8);
        this.qdata[1] = (byte)(queryno & 0xFF);
        int val = 0x100 | this.opcode << 11;
        this.qdata[2] = (byte)(val >> 8);
        this.qdata[3] = (byte)(val & 0xFF);
        this.qdata[4] = (byte)(req.length >> 8);
        this.qdata[5] = (byte)(req.length & 0xFF);
        int idx = 12;
        int i2 = 0;
        while (i2 < req.length) {
            len = req[i2].length();
            System.arraycopy(req[i2].getData(), 0, this.qdata, idx, len);
            idx += len;
            ++i2;
        }
    }

    public byte[] getQueryData() {
        return this.qdata;
    }

    public byte[] getResultData() throws IllegalStateException {
        if (this.data == null) {
            throw new IllegalStateException("runQuery() has not been called yet");
        }
        return this.data;
    }
}

