/*
 * Decompiled with CFR 0.152.
 */
package org.wonderly.net.dns;

import java.io.IOException;
import org.wonderly.net.dns.RR;

public class ARR
extends RR {
    String host;
    String addr;
    int recs = 1;
    int dlen;

    public String toString() {
        return String.valueOf(this.host) + "\t\t" + super.toString() + "\t" + this.addr;
    }

    public ARR(byte[] pkt, int cidx) {
        super(pkt, cidx, 1);
    }

    public String getHost() {
        return this.host;
    }

    public String getIPAddress() throws IOException {
        return this.addr;
    }

    public int getRecordCount() {
        return this.recs;
    }

    public int dataLength() {
        return this.dlen;
    }

    public void processRecord(int cidx) {
        StringBuffer buf = new StringBuffer();
        int nmlen = cidx;
        int fidx = cidx;
        cidx = RR.extractName(this.rdata, cidx, this.rdata.length, buf);
        this.host = buf.toString();
        nmlen = cidx - nmlen;
        cidx = this.setParameters(this.rdata, cidx);
        byte b1 = this.rdata[cidx++];
        byte b2 = this.rdata[cidx++];
        byte b3 = this.rdata[cidx++];
        byte b4 = this.rdata[cidx++];
        this.addr = String.valueOf(b1 & 0xFF) + "." + (b2 & 0xFF) + "." + (b3 & 0xFF) + "." + (b4 & 0xFF);
        this.dlen = cidx - fidx;
    }
}

