/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.AbstractMP3Fragment;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractFrameBodyTextInformation;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.lyrics3.AbstractLyrics3v2FieldBody;
import org.farng.mp3.lyrics3.FieldBodyAUT;
import org.farng.mp3.lyrics3.FieldBodyEAL;
import org.farng.mp3.lyrics3.FieldBodyEAR;
import org.farng.mp3.lyrics3.FieldBodyETT;
import org.farng.mp3.lyrics3.FieldBodyIMG;
import org.farng.mp3.lyrics3.FieldBodyIND;
import org.farng.mp3.lyrics3.FieldBodyINF;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.FieldBodyUnsupported;

public class Lyrics3v2Field
extends AbstractMP3Fragment {
    public Lyrics3v2Field() {
    }

    public Lyrics3v2Field(Lyrics3v2Field lyrics3v2Field) {
        super(lyrics3v2Field);
    }

    public Lyrics3v2Field(AbstractLyrics3v2FieldBody abstractLyrics3v2FieldBody) {
        super(abstractLyrics3v2FieldBody);
    }

    public Lyrics3v2Field(AbstractID3v2Frame abstractID3v2Frame) throws TagException {
        String string = abstractID3v2Frame.getIdentifier();
        if (string.startsWith("USLT")) {
            this.setBody(new FieldBodyLYR(""));
            ((FieldBodyLYR)this.getBody()).addLyric((FrameBodyUSLT)abstractID3v2Frame.getBody());
        } else if (string.startsWith("SYLT")) {
            this.setBody(new FieldBodyLYR(""));
            ((FieldBodyLYR)this.getBody()).addLyric((FrameBodySYLT)abstractID3v2Frame.getBody());
        } else if (string.startsWith("COMM")) {
            String string2 = new String(((FrameBodyCOMM)abstractID3v2Frame.getBody()).getText());
            this.setBody(new FieldBodyINF(string2));
        } else if (string.equals("TCOM")) {
            AbstractFrameBodyTextInformation abstractFrameBodyTextInformation = (AbstractFrameBodyTextInformation)abstractID3v2Frame.getBody();
            this.setBody(new FieldBodyAUT(""));
            if (abstractFrameBodyTextInformation != null && abstractFrameBodyTextInformation.getText().length() > 0) {
                this.setBody(new FieldBodyAUT(abstractFrameBodyTextInformation.getText()));
            }
        } else if (string.equals("TALB")) {
            AbstractFrameBodyTextInformation abstractFrameBodyTextInformation = (AbstractFrameBodyTextInformation)abstractID3v2Frame.getBody();
            if (abstractFrameBodyTextInformation != null && abstractFrameBodyTextInformation.getText().length() > 0) {
                this.setBody(new FieldBodyEAL(abstractFrameBodyTextInformation.getText()));
            }
        } else if (string.equals("TPE1")) {
            AbstractFrameBodyTextInformation abstractFrameBodyTextInformation = (AbstractFrameBodyTextInformation)abstractID3v2Frame.getBody();
            if (abstractFrameBodyTextInformation != null && abstractFrameBodyTextInformation.getText().length() > 0) {
                this.setBody(new FieldBodyEAR(abstractFrameBodyTextInformation.getText()));
            }
        } else if (string.equals("TIT2")) {
            AbstractFrameBodyTextInformation abstractFrameBodyTextInformation = (AbstractFrameBodyTextInformation)abstractID3v2Frame.getBody();
            if (abstractFrameBodyTextInformation != null && abstractFrameBodyTextInformation.getText().length() > 0) {
                this.setBody(new FieldBodyETT(abstractFrameBodyTextInformation.getText()));
            }
        } else {
            throw new TagException("Cannot create Lyrics3v2 field from given ID3v2 frame");
        }
    }

    public Lyrics3v2Field(RandomAccessFile randomAccessFile) throws InvalidTagException, IOException {
        this.read(randomAccessFile);
    }

    public String getIdentifier() {
        if (this.getBody() == null) {
            return "";
        }
        return this.getBody().getIdentifier();
    }

    public int getSize() {
        return this.getBody().getSize() + 5 + this.getIdentifier().length();
    }

    public void read(RandomAccessFile randomAccessFile) throws InvalidTagException, IOException {
        long l;
        byte by;
        byte[] byArray = new byte[6];
        do {
            l = randomAccessFile.getFilePointer();
        } while ((by = randomAccessFile.readByte()) == 0);
        randomAccessFile.seek(l);
        randomAccessFile.read(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        if (!TagUtility.isLyrics3v2FieldIdentifier(string)) {
            throw new InvalidTagException(string + " is not a valid ID3v2.4 frame");
        }
        this.setBody(this.readBody(string, randomAccessFile));
    }

    public String toString() {
        if (this.getBody() == null) {
            return "";
        }
        return this.getBody().toString();
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        if (this.getBody().getSize() > 0 || TagOptionSingleton.getInstance().isLyrics3SaveEmptyField()) {
            byte[] byArray = new byte[3];
            String string = this.getIdentifier();
            for (int i = 0; i < string.length(); ++i) {
                byArray[i] = (byte)string.charAt(i);
            }
            randomAccessFile.write(byArray, 0, string.length());
            this.getBody().write(randomAccessFile);
        }
    }

    private AbstractLyrics3v2FieldBody readBody(String string, RandomAccessFile randomAccessFile) throws InvalidTagException, IOException {
        AbstractLyrics3v2FieldBody abstractLyrics3v2FieldBody = string.equals("AUT") ? new FieldBodyAUT(randomAccessFile) : (string.equals("EAL") ? new FieldBodyEAL(randomAccessFile) : (string.equals("EAR") ? new FieldBodyEAR(randomAccessFile) : (string.equals("ETT") ? new FieldBodyETT(randomAccessFile) : (string.equals("IMG") ? new FieldBodyIMG(randomAccessFile) : (string.equals("IND") ? new FieldBodyIND(randomAccessFile) : (string.equals("INF") ? new FieldBodyINF(randomAccessFile) : (string.equals("LYR") ? new FieldBodyLYR(randomAccessFile) : new FieldBodyUnsupported(randomAccessFile))))))));
        return abstractLyrics3v2FieldBody;
    }
}

