/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagOptionSingleton;

public class TagUtility {
    private static final int UPPERCASE = -32;
    private static final Map capitalizationMap = new HashMap(32);

    private TagUtility() {
    }

    public static String getFrameDescription(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        String string2 = null;
        if (string.length() > 2) {
            String string3;
            if (string.length() == 4 && (string2 = (String)TagConstant.id3v2_4FrameIdToString.get(string3 = string.substring(0, 4))) == null) {
                string2 = (String)TagConstant.id3v2_3FrameIdToString.get(string3);
            }
            if (string2 == null) {
                string2 = (String)TagConstant.id3v2_2FrameIdToString.get(string.substring(0, 3));
            }
            if (string2 == null) {
                string2 = (String)TagConstant.lyrics3v2FieldIdToString.get(string.substring(0, 3));
            }
        }
        return string2;
    }

    public static boolean isID3v2_2FrameIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 3) {
            return false;
        }
        if (string.length() == 3) {
            return TagConstant.id3v2_2FrameIdToString.containsKey(string);
        }
        String string2 = string.toUpperCase();
        if (string2.charAt(3) >= 'A' && string2.charAt(3) <= 'Z') {
            return TagConstant.id3v2_2FrameIdToString.containsKey(string2.substring(0, 4));
        }
        return TagConstant.id3v2_2FrameIdToString.containsKey(string2.subSequence(0, 3));
    }

    public static boolean isID3v2_3FrameIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 4) {
            return false;
        }
        return TagConstant.id3v2_3FrameIdToString.containsKey(string.substring(0, 4));
    }

    public static boolean isID3v2_4FrameIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 4) {
            return false;
        }
        return TagConstant.id3v2_4FrameIdToString.containsKey(string.substring(0, 4));
    }

    public static boolean isLyrics3v2FieldIdentifier(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 3) {
            return false;
        }
        return TagConstant.lyrics3v2FieldIdToString.containsKey(string.substring(0, 3));
    }

    public static boolean isMatchingParenthesis(String string) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        TagOptionSingleton tagOptionSingleton = TagOptionSingleton.getInstance();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (tagOptionSingleton.isCloseParenthesis(Character.toString(c))) {
                return false;
            }
            if (!tagOptionSingleton.isOpenParenthesis(Character.toString(c)) || (i = TagUtility.findMatchingParenthesis(string, i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static long getWholeNumber(Object object) {
        long l;
        if (object == null) {
            throw new NullPointerException("Value is null");
        }
        if (object instanceof String) {
            l = Long.parseLong((String)object);
        } else if (object instanceof Byte) {
            l = ((Byte)object).byteValue();
        } else if (object instanceof Short) {
            l = ((Short)object).shortValue();
        } else if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        } else if (object instanceof Long) {
            l = (Long)object;
        } else {
            throw new IllegalArgumentException("Unsupported value class: " + object.getClass().getName());
        }
        return l;
    }

    public static String addTimeStampToTextArea(String string, int n) {
        String string2;
        if (string.length() == 0) {
            string2 = "[00:00]";
        } else {
            int n2 = n;
            if (string.charAt(n2 = Math.min(n2, string.length() - 1)) == '\n') {
                --n2;
            }
            while (n2 > 0 && string.charAt(n2) != '\n') {
                --n2;
            }
            if (n2 == 0) {
                string2 = "[00:00]" + string;
            } else {
                String string3 = string.substring(0, ++n2);
                String string4 = string.substring(n2);
                string2 = string3 + "[00:00]" + string4;
            }
        }
        return string2;
    }

    public static String appendBeforeExtension(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string == null) {
            return string2;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string + string2;
        }
        return string.substring(0, n) + string2 + string.substring(n);
    }

    public static String convertFrameID2_2to2_3(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 3) {
            return null;
        }
        return (String)TagConstant.id3v2_2ToId3v2_3.get(string.subSequence(0, 3));
    }

    public static String convertFrameID2_2to2_4(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 3) {
            return null;
        }
        String string2 = (String)TagConstant.id3v2_2ToId3v2_3.get(string.substring(0, 3));
        if (string2 != null) {
            string2 = (String)TagConstant.id3v2_3ToId3v2_4.get(string2);
        }
        return string2;
    }

    public static String convertFrameID2_3to2_2(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 4) {
            return null;
        }
        return (String)TagConstant.id3v2_3ToId3v2_2.get(string.substring(0, 4));
    }

    public static String convertFrameID2_3to2_4(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 4) {
            return null;
        }
        return (String)TagConstant.id3v2_3ToId3v2_4.get(string.substring(0, 4));
    }

    public static String convertFrameID2_4to2_2(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 4) {
            return null;
        }
        String string2 = (String)TagConstant.id3v2_4ToId3v2_3.get(string.substring(0, 4));
        if (string2 != null) {
            string2 = (String)TagConstant.id3v2_3ToId3v2_2.get(string2);
        }
        return string2;
    }

    public static String convertFrameID2_4to2_3(String string) {
        if (string == null) {
            throw new NullPointerException("Identifier is null");
        }
        if (string.length() < 4) {
            return null;
        }
        return (String)TagConstant.id3v2_4ToId3v2_3.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new NullPointerException("Source is null");
        }
        if (file2 == null) {
            throw new NullPointerException("Destination is null");
        }
        if (!file.exists()) {
            throw new NullPointerException("Source file not found.");
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            if (file2.exists()) {
                file2.delete();
            }
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            fileOutputStream = new FileOutputStream(file2);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            byte[] byArray = new byte[1024];
            int n = bufferedInputStream.read(byArray);
            while (n != -1) {
                bufferedOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static Object copyObject(Object object) {
        if (object == null) {
            return null;
        }
        try {
            Class[] classArray = new Class[]{object.getClass()};
            Constructor<?> constructor = object.getClass().getConstructor(classArray);
            Object[] objectArray = new Object[]{object};
            return constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("NoSuchMethodException: Error finding constructor to create copy");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("IllegalAccessException: No access to run constructor to create copy");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("InstantiationException: Unable to instantiate constructor to copy");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("InvocationTargetException: Unable to invoke constructor to create copy");
        }
    }

    public static int findMatchingParenthesis(String string, int n) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Index to image string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        TagOptionSingleton tagOptionSingleton = TagOptionSingleton.getInstance();
        Stack<String> stack = new Stack<String>();
        if (n >= 0) {
            int n2 = string.length();
            if (n2 == 0) {
                return 0;
            }
            for (int i = n; i < n2; ++i) {
                char c = string.charAt(i);
                String string2 = c + "";
                if (tagOptionSingleton.isOpenParenthesis(string2)) {
                    stack.push(string2);
                }
                if (tagOptionSingleton.isCloseParenthesis(string2)) {
                    if (stack.size() <= 0) {
                        return -1;
                    }
                    String string3 = (String)stack.pop();
                    if (!tagOptionSingleton.getCloseParenthesis(string3).equals(string2)) {
                        return -1;
                    }
                }
                if (stack.size() > 0) continue;
                return i;
            }
        }
        return -1;
    }

    public static long findNumber(String string) throws TagException {
        return TagUtility.findNumber(string, 0);
    }

    public static long findNumber(String string, int n) throws TagException {
        int n2;
        int n3;
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        for (n3 = n; n3 < string.length() && (string.charAt(n3) < '0' || string.charAt(n3) > '9') && string.charAt(n3) != '-'; ++n3) {
        }
        for (n2 = n3 + 1; n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9'; ++n2) {
        }
        if (n2 > string.length() || n2 <= n3) {
            throw new TagException("Unable to find integer in string: " + string);
        }
        long l = Long.parseLong(string.substring(n3, n2));
        return l;
    }

    public static String padString(String string, int n, char c, boolean bl) {
        int n2;
        if (n < 0) {
            return string;
        }
        if (n == 0) {
            if (string == null) {
                return "";
            }
            return string;
        }
        int n3 = 0;
        if (string != null) {
            n3 = string.length();
        }
        if (n3 >= n) {
            return string;
        }
        char[] cArray = new char[n];
        int n4 = 0;
        if (bl) {
            for (n2 = 0; n2 < n - n3; ++n2) {
                cArray[n4++] = c;
            }
        }
        if (string != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n4++] = string.charAt(n2);
            }
        }
        if (!bl) {
            for (n2 = 0; n2 < n - n3; ++n2) {
                cArray[n4++] = c;
            }
        }
        return new String(cArray);
    }

    public static String replaceEOLNwithCRLF(String string) {
        String string2 = null;
        if (string != null) {
            string2 = "";
            int n = 0;
            int n2 = string.indexOf(10);
            while (n2 >= 0) {
                string2 = string2 + string.substring(n, n2) + TagConstant.SEPERATOR_LINE;
                n = n2 + 1;
                n2 = string.indexOf(10, n);
            }
            string2 = string2 + string.substring(n);
        }
        return string2;
    }

    public static String replaceWord(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("Source is null");
        }
        if (string2 == null) {
            throw new NullPointerException("Old string (string to be replaced) is null");
        }
        if (string.length() > 0 && string2.length() > 0) {
            if (string3 == null) {
                string3 = "";
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.indexOf(string2);
            int n2 = string2.length();
            while (n >= 0) {
                if (n == 0 && Character.isWhitespace(stringBuffer.charAt(n + n2)) || Character.isWhitespace(stringBuffer.charAt(n - 1)) && n + n2 >= stringBuffer.length() || Character.isWhitespace(stringBuffer.charAt(n - 1)) && Character.isWhitespace(stringBuffer.charAt(n + n2))) {
                    stringBuffer.replace(n, n + n2, string3);
                }
                n = stringBuffer.indexOf(string2, n);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String stripChar(String string, char c) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            cArray[n++] = string.charAt(i);
        }
        return new String(cArray, 0, n);
    }

    public static String toSentenceCase(String string, boolean bl) {
        String string2;
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringBuffer.append(TagUtility.capitalizeWord(string2, bl));
            stringBuffer.append(' ');
            ++n2;
        }
        while (stringTokenizer.hasMoreTokens() && n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
            if (capitalizationMap.containsKey(string2.toLowerCase())) {
                stringBuffer.append(capitalizationMap.get(string2.toLowerCase()));
            } else if (bl && string2.toUpperCase().equals(string2)) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2.toLowerCase());
            }
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String toTitleCase(String string, boolean bl) {
        String string2;
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringBuffer.append(TagUtility.capitalizeWord(string2, bl));
            stringBuffer.append(' ');
            ++n2;
        }
        while (stringTokenizer.hasMoreTokens() && n2 < n - 1) {
            string2 = stringTokenizer.nextToken();
            ++n2;
            if (capitalizationMap.containsKey(string2.toLowerCase())) {
                stringBuffer.append(capitalizationMap.get(string2.toLowerCase()));
            } else {
                stringBuffer.append(TagUtility.capitalizeWord(string2, bl));
            }
            stringBuffer.append(' ');
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            stringBuffer.append(TagUtility.capitalizeWord(string2, bl));
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static String truncate(String string, int n) {
        if (string == null) {
            throw new NullPointerException("String is null");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Length is less than zero");
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string.trim();
    }

    private static StringBuffer capitalizeWord(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (bl && string.toUpperCase().equals(string)) {
            stringBuffer.append(string);
        } else {
            string = string.toLowerCase();
            int n2 = string.length();
            char c = string.charAt(n);
            while ((c < 'a' || c > 'z') && n < n2 - 1) {
                c = string.charAt(++n);
            }
            if (n < n2) {
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append((char)(c + UPPERCASE));
                stringBuffer.append(string.substring(n + 1));
            } else {
                stringBuffer.append(string);
            }
        }
        return stringBuffer;
    }

    static {
        Iterator iterator = TagOptionSingleton.getInstance().getUpperLowerCaseWordListIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            capitalizationMap.put(string.toLowerCase(), string);
        }
    }
}

