/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.FilenameTag;
import org.farng.mp3.filename.FilenameTagBuilder;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v1_1;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.Lyrics3v1;
import org.farng.mp3.lyrics3.Lyrics3v2;

public class MP3File {
    private AbstractID3v2 id3v2tag;
    private AbstractLyrics3 lyrics3tag;
    private File mp3file;
    private FilenameTag filenameTag;
    private ID3v1 id3v1tag;
    private boolean copyProtected;
    private boolean home;
    private boolean padding;
    private boolean privacy;
    private boolean protection;
    private boolean variableBitRate;
    private byte emphasis;
    private byte layer;
    private byte mode;
    private byte modeExtension;
    private byte mpegVersion;
    private double frequency;
    private int bitRate;

    public MP3File() {
    }

    public MP3File(MP3File mP3File) {
        this.copyProtected = mP3File.copyProtected;
        this.home = mP3File.home;
        this.padding = mP3File.padding;
        this.privacy = mP3File.privacy;
        this.protection = mP3File.protection;
        this.variableBitRate = mP3File.variableBitRate;
        this.emphasis = mP3File.emphasis;
        this.layer = mP3File.layer;
        this.mode = mP3File.mode;
        this.modeExtension = mP3File.modeExtension;
        this.mpegVersion = mP3File.mpegVersion;
        this.frequency = mP3File.frequency;
        this.bitRate = mP3File.bitRate;
        this.mp3file = new File(mP3File.mp3file.getAbsolutePath());
        this.filenameTag = new FilenameTag(mP3File.filenameTag);
        this.id3v2tag = (AbstractID3v2)TagUtility.copyObject(mP3File.id3v2tag);
        this.lyrics3tag = (AbstractLyrics3)TagUtility.copyObject(mP3File.lyrics3tag);
        this.id3v1tag = (ID3v1)TagUtility.copyObject(mP3File.id3v1tag);
    }

    public MP3File(String string) throws IOException, TagException {
        this(new File(string));
    }

    public MP3File(File file) throws IOException, TagException {
        this(file, true);
    }

    public MP3File(File file, boolean bl) throws IOException, TagException {
        this.mp3file = file;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, bl ? "rw" : "r");
        try {
            this.id3v1tag = new ID3v1_1(randomAccessFile);
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        try {
            if (this.id3v1tag == null) {
                this.id3v1tag = new ID3v1(randomAccessFile);
            }
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        try {
            this.id3v2tag = new ID3v2_4(randomAccessFile);
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        try {
            if (this.id3v2tag == null) {
                this.id3v2tag = new ID3v2_3(randomAccessFile);
            }
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        try {
            if (this.id3v2tag == null) {
                this.id3v2tag = new ID3v2_2(randomAccessFile);
            }
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        try {
            this.lyrics3tag = new Lyrics3v2(randomAccessFile);
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        try {
            if (this.lyrics3tag == null) {
                this.lyrics3tag = new Lyrics3v1(randomAccessFile);
            }
        }
        catch (TagNotFoundException tagNotFoundException) {
            // empty catch block
        }
        randomAccessFile.close();
        try {
            this.filenameTag = FilenameTagBuilder.createFilenameTagFromMP3File(this);
        }
        catch (Exception exception) {
            throw new TagException("Unable to create FilenameTag", exception);
        }
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public boolean isCopyProtected() {
        return this.copyProtected;
    }

    public byte getEmphasis() {
        return this.emphasis;
    }

    public void setFilenameTag(FilenameTag filenameTag) {
        this.filenameTag = filenameTag;
    }

    public FilenameTag getFilenameTag() {
        return this.filenameTag;
    }

    public void setFrameAcrossTags(AbstractID3v2Frame abstractID3v2Frame) {
        ID3v2_4 iD3v2_4;
        if (this.id3v1tag != null) {
            iD3v2_4 = new ID3v2_4((AbstractMP3Tag)this.id3v1tag);
            iD3v2_4.setFrame(abstractID3v2Frame);
            this.id3v1tag.overwrite(iD3v2_4);
        }
        if (this.id3v2tag != null) {
            this.id3v2tag.setFrame(abstractID3v2Frame);
        }
        if (this.lyrics3tag != null) {
            iD3v2_4 = new ID3v2_4(this.lyrics3tag);
            iD3v2_4.setFrame(abstractID3v2Frame);
            this.lyrics3tag = new Lyrics3v2(iD3v2_4);
        }
        if (this.filenameTag != null) {
            this.filenameTag.setFrame(abstractID3v2Frame);
        }
    }

    public List getFrameAcrossTags(String string) {
        if (string != null && string.length() > 0) {
            Iterator iterator;
            ID3v2_4 iD3v2_4;
            ArrayList arrayList = new ArrayList(32);
            if (this.id3v1tag != null && (iD3v2_4 = new ID3v2_4((AbstractMP3Tag)this.id3v1tag)).hasFrameOfType(string)) {
                iterator = iD3v2_4.getFrameOfType(string);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            if (this.id3v2tag != null && this.id3v2tag.hasFrameOfType(string)) {
                iterator = this.id3v2tag.getFrameOfType(string);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            if (this.lyrics3tag != null && (iD3v2_4 = new ID3v2_4(this.lyrics3tag)).hasFrameOfType(string)) {
                iterator = iD3v2_4.getFrameOfType(string);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            if (this.filenameTag != null && this.filenameTag.hasFrameOfType(string)) {
                iterator = this.filenameTag.getFrameOfType(string);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            return arrayList;
        }
        return null;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public boolean isHome() {
        return this.home;
    }

    public void setID3v1Tag(AbstractMP3Tag abstractMP3Tag) {
        this.id3v1tag = new ID3v1_1(abstractMP3Tag);
    }

    public void setID3v1Tag(ID3v1 iD3v1) {
        this.id3v1tag = iD3v1;
    }

    public ID3v1 getID3v1Tag() {
        return this.id3v1tag;
    }

    public void setID3v2Tag(AbstractMP3Tag abstractMP3Tag) {
        this.id3v2tag = new ID3v2_4(abstractMP3Tag);
    }

    public void setID3v2Tag(AbstractID3v2 abstractID3v2) {
        this.id3v2tag = abstractID3v2;
    }

    public AbstractID3v2 getID3v2Tag() {
        return this.id3v2tag;
    }

    public byte getLayer() {
        return this.layer;
    }

    public void setLyrics3Tag(AbstractMP3Tag abstractMP3Tag) {
        this.lyrics3tag = new Lyrics3v2(abstractMP3Tag);
    }

    public void setLyrics3Tag(AbstractLyrics3 abstractLyrics3) {
        this.lyrics3tag = abstractLyrics3;
    }

    public AbstractLyrics3 getLyrics3Tag() {
        return this.lyrics3tag;
    }

    public byte getMode() {
        return this.mode;
    }

    public byte getModeExtension() {
        return this.modeExtension;
    }

    public long getMp3StartByte() throws IOException, FileNotFoundException {
        return this.getMp3StartByte(this.mp3file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMp3StartByte(File file) throws IOException, FileNotFoundException {
        RandomAccessFile randomAccessFile = null;
        long l = 0L;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            this.seekMP3Frame(randomAccessFile);
            l = randomAccessFile.getFilePointer();
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        return l;
    }

    public void setMp3file(File file) {
        this.mp3file = file;
    }

    public File getMp3file() {
        return this.mp3file;
    }

    public byte getMpegVersion() {
        return this.mpegVersion;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public boolean isPrivacy() {
        return this.privacy;
    }

    public boolean isProtection() {
        return this.protection;
    }

    public boolean isUnsynchronized() {
        return this.getUnsynchronizedFragments().size() > 0;
    }

    public Set getUnsynchronizedFragments() {
        ID3v2_4 iD3v2_4 = new ID3v2_4((AbstractMP3Tag)this.id3v2tag);
        HashSet<String> hashSet = new HashSet<String>(32);
        iD3v2_4.append(this.id3v1tag);
        iD3v2_4.append(this.lyrics3tag);
        iD3v2_4.append(this.filenameTag);
        iD3v2_4.append(this.id3v2tag);
        ID3v2_4 iD3v2_42 = new ID3v2_4((AbstractMP3Tag)this.id3v1tag);
        ID3v2_4 iD3v2_43 = new ID3v2_4(this.lyrics3tag);
        ID3v2_4 iD3v2_44 = new ID3v2_4(this.filenameTag);
        AbstractID3v2 abstractID3v2 = this.id3v2tag;
        Iterator iterator = iD3v2_4.iterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
            String string = abstractID3v2Frame.getIdentifier();
            if (abstractID3v2 != null && abstractID3v2.hasFrame(string) && !abstractID3v2.getFrame(string).isSubsetOf(abstractID3v2Frame)) {
                hashSet.add(string);
            }
            if (iD3v2_42.hasFrame(string) && !iD3v2_42.getFrame(string).isSubsetOf(abstractID3v2Frame)) {
                hashSet.add(string);
            }
            if (iD3v2_43.hasFrame(string) && !iD3v2_43.getFrame(string).isSubsetOf(abstractID3v2Frame)) {
                hashSet.add(string);
            }
            if (!iD3v2_44.hasFrame(string) || iD3v2_44.getFrame(string).isSubsetOf(abstractID3v2Frame)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void setVariableBitRate(boolean bl) {
        this.variableBitRate = bl;
    }

    public boolean isVariableBitRate() {
        return this.variableBitRate;
    }

    public boolean adjustID3v2Padding() throws FileNotFoundException, IOException, TagException {
        return this.adjustID3v2Padding(TagOptionSingleton.getInstance().getId3v2PaddingSize(), TagOptionSingleton.getInstance().isId3v2PaddingWillShorten(), TagOptionSingleton.getInstance().isId3v2PaddingCopyTag(), this.mp3file);
    }

    public boolean adjustID3v2Padding(int n, boolean bl, boolean bl2) throws FileNotFoundException, IOException, TagException {
        return this.adjustID3v2Padding(n, bl, bl2, this.mp3file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean adjustID3v2Padding(int n, boolean bl, boolean bl2, File file) throws FileNotFoundException, IOException, TagException {
        boolean bl3;
        File file2;
        File file3;
        FileOutputStream fileOutputStream;
        block28: {
            FileInputStream fileInputStream;
            block26: {
                boolean bl4;
                block27: {
                    int n2 = 0;
                    long l = this.getMp3StartByte(file);
                    long l2 = n;
                    fileOutputStream = null;
                    fileInputStream = null;
                    file3 = null;
                    file2 = null;
                    if (l2 < 0L) {
                        throw new TagException("Invalid paddingSize: " + l2);
                    }
                    if (this.hasID3v2Tag()) {
                        n2 = this.getID3v2Tag().getSize();
                    }
                    if (l2 != 0L) {
                        while (l2 < (long)n2) {
                            l2 = (long)((float)l2 * TagOptionSingleton.getInstance().getId3v2PaddingMultiplier());
                        }
                    }
                    if (l2 < l && !bl) {
                        return false;
                    }
                    if (l2 == l) {
                        return false;
                    }
                    try {
                        byte[] byArray;
                        file2 = File.createTempFile("temp", ".mp3", file.getParentFile());
                        fileOutputStream = new FileOutputStream(file2);
                        fileInputStream = new FileInputStream(file);
                        if (bl2) {
                            if (l2 < l && bl) {
                                byArray = new byte[(int)l2];
                                fileInputStream.read(byArray, 0, byArray.length);
                                fileOutputStream.write(byArray, 0, byArray.length);
                                byArray = new byte[(int)(l - l2)];
                                fileInputStream.read(byArray, 0, byArray.length);
                            } else {
                                byArray = new byte[(int)l];
                                fileInputStream.read(byArray, 0, byArray.length);
                                fileOutputStream.write(byArray, 0, byArray.length);
                                if (l2 - l > 0L) {
                                    byArray = new byte[(int)(l2 - l)];
                                    fileOutputStream.write(byArray, 0, byArray.length);
                                }
                            }
                        } else {
                            byArray = new byte[(int)l2];
                            fileInputStream.skip(l);
                            fileOutputStream.write(byArray, 0, byArray.length);
                        }
                        byArray = new byte[1024];
                        int n3 = fileInputStream.read(byArray, 0, byArray.length);
                        while (n3 == 1024) {
                            fileOutputStream.write(byArray, 0, byArray.length);
                            n3 = fileInputStream.read(byArray, 0, byArray.length);
                        }
                        if (n3 != -1) {
                            fileOutputStream.write(byArray, 0, n3);
                        }
                        file3 = new File(file.getParentFile(), TagUtility.appendBeforeExtension(file.getName(), ".original"));
                        TagUtility.copyFile(file, file3);
                        if (file3.exists()) {
                            file3.setLastModified(file.lastModified());
                            break block26;
                        }
                        bl4 = false;
                        Object var18_16 = null;
                        if (fileInputStream == null) break block27;
                    }
                    catch (Throwable throwable) {
                        block29: {
                            Object var18_18 = null;
                            if (fileInputStream != null) {
                                fileInputStream.getFD().sync();
                                fileInputStream.close();
                            }
                            if (fileOutputStream != null) {
                                fileOutputStream.getFD().sync();
                                fileOutputStream.close();
                            }
                            if (file3 != null && !TagOptionSingleton.getInstance().isOriginalSavedAfterAdjustingID3v2Padding()) {
                                file3.delete();
                            }
                            if (file2 == null) break block29;
                            file2.delete();
                        }
                        throw throwable;
                    }
                    fileInputStream.getFD().sync();
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.getFD().sync();
                    fileOutputStream.close();
                }
                if (file3 != null && !TagOptionSingleton.getInstance().isOriginalSavedAfterAdjustingID3v2Padding()) {
                    file3.delete();
                }
                if (file2 != null) {
                    file2.delete();
                }
                return bl4;
            }
            TagUtility.copyFile(file2, file);
            bl3 = true;
            Object var18_17 = null;
            if (fileInputStream == null) break block28;
            fileInputStream.getFD().sync();
            fileInputStream.close();
        }
        if (fileOutputStream != null) {
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
        }
        if (file3 != null && !TagOptionSingleton.getInstance().isOriginalSavedAfterAdjustingID3v2Padding()) {
            file3.delete();
        }
        if (file2 != null) {
            file2.delete();
        }
        return bl3;
    }

    public void delete(AbstractMP3Tag abstractMP3Tag) throws FileNotFoundException, IOException {
        abstractMP3Tag.delete(new RandomAccessFile(this.mp3file, "rw"));
    }

    public boolean hasFilenameTag() {
        return this.filenameTag != null;
    }

    public boolean hasID3v1Tag() {
        return this.id3v1tag != null;
    }

    public boolean hasID3v2Tag() {
        return this.id3v2tag != null;
    }

    public boolean hasLyrics3Tag() {
        return this.lyrics3tag != null;
    }

    public void save() throws IOException, TagException {
        this.save(this.mp3file, TagOptionSingleton.getInstance().getDefaultSaveMode());
    }

    public void save(int n) throws IOException, TagException {
        this.save(this.mp3file, n);
    }

    public void save(String string) throws IOException, TagException {
        this.save(new File(string), TagOptionSingleton.getInstance().getDefaultSaveMode());
    }

    public void save(File file) throws IOException, TagException {
        this.save(file, TagOptionSingleton.getInstance().getDefaultSaveMode());
    }

    public void save(String string, int n) throws IOException, TagException {
        this.save(new File(string), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, int n) throws IOException, TagException {
        if (n < 1 || n > 3) {
            throw new TagException("Invalid Save Mode");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            if (this.id3v2tag != null) {
                this.adjustID3v2Padding(TagOptionSingleton.getInstance().getId3v2PaddingSize(), TagOptionSingleton.getInstance().isId3v2PaddingWillShorten(), TagOptionSingleton.getInstance().isId3v2PaddingCopyTag(), file);
            }
            randomAccessFile = new RandomAccessFile(file, "rw");
            if (TagOptionSingleton.getInstance().isId3v2Save()) {
                if (this.id3v2tag == null) {
                    if (n == 2) {
                        new ID3v2_4().delete(randomAccessFile);
                    }
                } else if (n == 1) {
                    this.id3v2tag.write(randomAccessFile);
                } else if (n == 3) {
                    this.id3v2tag.append(randomAccessFile);
                } else if (n == 2) {
                    this.id3v2tag.overwrite(randomAccessFile);
                }
            }
            if (TagOptionSingleton.getInstance().isLyrics3Save()) {
                if (this.lyrics3tag == null) {
                    if (n == 2) {
                        new Lyrics3v2().delete(randomAccessFile);
                    }
                } else if (n == 1) {
                    this.lyrics3tag.write(randomAccessFile);
                } else if (n == 3) {
                    this.lyrics3tag.append(randomAccessFile);
                } else if (n == 2) {
                    this.lyrics3tag.overwrite(randomAccessFile);
                }
            }
            if (TagOptionSingleton.getInstance().isId3v1Save()) {
                if (this.id3v1tag == null) {
                    if (n == 2) {
                        new ID3v1().delete(randomAccessFile);
                    }
                } else if (n == 1) {
                    this.id3v1tag.write(randomAccessFile);
                } else if (n == 3) {
                    this.id3v1tag.append(randomAccessFile);
                } else if (n == 2) {
                    this.id3v1tag.overwrite(randomAccessFile);
                }
            }
            if (TagOptionSingleton.getInstance().isFilenameTagSave() && this.filenameTag != null) {
                if (n == 1) {
                    this.filenameTag.write(randomAccessFile);
                } else if (n == 3) {
                    this.filenameTag.append(randomAccessFile);
                } else if (n == 2) {
                    this.filenameTag.overwrite(randomAccessFile);
                }
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean seekMP3Frame() throws IOException {
        RandomAccessFile randomAccessFile = null;
        boolean bl = false;
        try {
            randomAccessFile = new RandomAccessFile(this.mp3file, "r");
            bl = this.seekMP3Frame(randomAccessFile);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        return bl;
    }

    public boolean seekMP3Frame(RandomAccessFile randomAccessFile) throws IOException {
        boolean bl = false;
        long l = 1L;
        this.variableBitRate = false;
        try {
            randomAccessFile.seek(0L);
            do {
                byte by;
                if ((by = randomAccessFile.readByte()) != -1) continue;
                l = randomAccessFile.getFilePointer();
                byte by2 = (byte)(randomAccessFile.readByte() & 0xFFFFFFE0);
                if (by2 == -32) {
                    randomAccessFile.seek(l - 1L);
                    bl = this.seekNextMP3Frame(randomAccessFile, TagOptionSingleton.getInstance().getNumberMP3SyncFrame());
                }
                randomAccessFile.seek(l);
            } while (!bl);
            randomAccessFile.seek(l - 1L);
        }
        catch (EOFException eOFException) {
            bl = false;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        return bl;
    }

    private int getFrameSize() {
        if (this.frequency == 0.0) {
            return 0;
        }
        boolean bl = this.padding;
        int n = this.layer == 3 ? (int)(((double)(12 * this.bitRate) / this.frequency + (double)bl) * 4.0) : (int)((double)(144 * this.bitRate) / this.frequency + (double)bl);
        return n;
    }

    private void readFrameHeader(RandomAccessFile randomAccessFile) throws IOException, TagNotFoundException, InvalidTagException {
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        if (byArray[0] != -1 || (byArray[1] & 0xFFFFFFE0) != -32) {
            throw new TagNotFoundException("MP3 Frame sync bits not found");
        }
        this.mpegVersion = (byte)((byArray[1] & 0x18) >> 3);
        this.layer = (byte)((byArray[1] & 6) >> 1);
        this.protection = (byArray[1] & 1) != 1;
        int n = byArray[2] & 0xF0 | byArray[1] & 8 | byArray[1] & 6;
        Long l = (Long)TagConstant.bitrate.get(new Long(n));
        if (l != null) {
            if (this.bitRate != 0 && l != (long)this.bitRate) {
                this.variableBitRate = true;
            }
        } else {
            throw new InvalidTagException("Invalid bit rate");
        }
        this.bitRate = l.intValue();
        int n2 = (byArray[2] & 0xC) >>> 2;
        if (this.mpegVersion == 3) {
            switch (n2) {
                case 0: {
                    this.frequency = 44.1;
                    break;
                }
                case 1: {
                    this.frequency = 48.0;
                    break;
                }
                case 2: {
                    this.frequency = 32.0;
                }
            }
        } else if (this.mpegVersion == 2) {
            switch (n2) {
                case 0: {
                    this.frequency = 22.05;
                    break;
                }
                case 1: {
                    this.frequency = 24.0;
                    break;
                }
                case 2: {
                    this.frequency = 16.0;
                }
            }
        } else if (this.mpegVersion == 0) {
            switch (n2) {
                case 0: {
                    this.frequency = 11.025;
                    break;
                }
                case 1: {
                    this.frequency = 12.0;
                    break;
                }
                case 2: {
                    this.frequency = 8.0;
                }
            }
        } else {
            throw new InvalidTagException("Invalid MPEG version");
        }
        this.padding = (byArray[2] & 2) != 0;
        this.privacy = (byArray[2] & 1) != 0;
        this.mode = (byte)((byArray[3] & 0xC0) >> 6);
        this.modeExtension = (byte)((byArray[3] & 0x30) >> 4);
        this.copyProtected = (byArray[3] & 8) != 0;
        this.home = (byArray[3] & 4) != 0;
        this.emphasis = (byte)(byArray[3] & 3);
    }

    private boolean seekNextMP3Frame(RandomAccessFile randomAccessFile, int n) throws IOException {
        boolean bl;
        if (n == 0) {
            bl = true;
        } else {
            try {
                this.readFrameHeader(randomAccessFile);
            }
            catch (TagException tagException) {
                return false;
            }
            int n2 = this.getFrameSize();
            if (n2 <= 0 || (long)n2 > randomAccessFile.length()) {
                return false;
            }
            byte[] byArray = new byte[n2 - 4];
            randomAccessFile.read(byArray);
            long l = randomAccessFile.getFilePointer();
            byte by = randomAccessFile.readByte();
            if (by == -1) {
                byte by2 = (byte)(randomAccessFile.readByte() & 0xFFFFFFE0);
                if (by2 == -32) {
                    randomAccessFile.seek(l);
                    bl = this.seekNextMP3Frame(randomAccessFile, n - 1);
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

