/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import org.ccil.cowan.tagsoup.PYXWriter;
import org.ccil.cowan.tagsoup.ScanHandler;
import org.ccil.cowan.tagsoup.Scanner;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTMLScanner
implements Scanner,
Locator {
    private static final int S_ANAME = 1;
    private static final int S_APOS = 2;
    private static final int S_AVAL = 3;
    private static final int S_BB = 4;
    private static final int S_BBC = 5;
    private static final int S_BBCD = 6;
    private static final int S_BBCDA = 7;
    private static final int S_BBCDAT = 8;
    private static final int S_BBCDATA = 9;
    private static final int S_CCRLF = 10;
    private static final int S_CDATA = 11;
    private static final int S_CDATA2 = 12;
    private static final int S_CDSECT = 13;
    private static final int S_CDSECT1 = 14;
    private static final int S_CDSECT2 = 15;
    private static final int S_COM = 16;
    private static final int S_COMCRLF = 17;
    private static final int S_COMD = 18;
    private static final int S_CRLF = 19;
    private static final int S_DECL = 20;
    private static final int S_DECL2 = 21;
    private static final int S_DONE = 22;
    private static final int S_EMPTYTAG = 23;
    private static final int S_ENT = 24;
    private static final int S_EQ = 25;
    private static final int S_ETAG = 26;
    private static final int S_GI = 27;
    private static final int S_NCR = 28;
    private static final int S_PCDATA = 29;
    private static final int S_PI = 30;
    private static final int S_PICRLF = 31;
    private static final int S_PITARGET = 32;
    private static final int S_QUOT = 33;
    private static final int S_STAGC = 34;
    private static final int S_TAG = 35;
    private static final int S_TAGWS = 36;
    private static final int S_XNCR = 37;
    private static final int A_ADUP = 1;
    private static final int A_ADUP_SAVE = 2;
    private static final int A_ADUP_STAGC = 3;
    private static final int A_ANAME = 4;
    private static final int A_ANAME_ADUP = 5;
    private static final int A_ANAME_ADUP_STAGC = 6;
    private static final int A_AVAL = 7;
    private static final int A_AVAL_STAGC = 8;
    private static final int A_CDATA = 9;
    private static final int A_CMNT = 10;
    private static final int A_DECL = 11;
    private static final int A_EMPTYTAG = 12;
    private static final int A_ENTITY = 13;
    private static final int A_ETAG = 14;
    private static final int A_GI = 15;
    private static final int A_GI_STAGC = 16;
    private static final int A_LF = 17;
    private static final int A_LT = 18;
    private static final int A_LT_PCDATA = 19;
    private static final int A_PCDATA = 20;
    private static final int A_PCDATA_SAVE_PUSH = 21;
    private static final int A_PI = 22;
    private static final int A_PITARGET = 23;
    private static final int A_PITARGET_PI = 24;
    private static final int A_SAVE = 25;
    private static final int A_SAVE_PUSH = 26;
    private static final int A_SKIP = 27;
    private static final int A_SP = 28;
    private static final int A_STAGC = 29;
    private static final int A_UNGET = 30;
    private static final int A_UNSAVE_PCDATA = 31;
    private static int[] statetable = new int[]{1, 47, 5, 23, 1, 61, 4, 3, 1, 62, 6, 29, 1, 0, 25, 1, 1, -1, 6, 22, 1, 32, 4, 25, 1, 13, 4, 25, 1, 10, 4, 25, 1, 9, 4, 25, 2, 38, 26, 24, 2, 39, 7, 36, 2, 0, 25, 2, 2, -1, 8, 22, 2, 32, 28, 2, 2, 13, 28, 2, 2, 10, 28, 2, 2, 9, 28, 2, 3, 34, 27, 33, 3, 39, 27, 2, 3, 62, 8, 29, 3, 0, 25, 34, 3, -1, 8, 22, 3, 32, 27, 3, 3, 13, 27, 3, 3, 10, 27, 3, 3, 9, 27, 3, 4, 67, 27, 5, 4, 0, 27, 20, 4, -1, 27, 22, 5, 68, 27, 6, 5, 0, 27, 20, 5, -1, 27, 22, 6, 65, 27, 7, 6, 0, 27, 20, 6, -1, 27, 22, 7, 84, 27, 8, 7, 0, 27, 20, 7, -1, 27, 22, 8, 65, 27, 9, 8, 0, 27, 20, 8, -1, 27, 22, 9, 91, 27, 13, 9, 0, 27, 20, 9, -1, 27, 22, 10, 0, 30, 11, 10, -1, 27, 22, 10, 10, 27, 11, 11, 60, 25, 12, 11, 13, 17, 10, 11, 0, 25, 11, 11, -1, 20, 22, 12, 47, 31, 26, 12, 0, 25, 11, 12, -1, 31, 22, 13, 93, 25, 14, 13, 0, 25, 13, 13, -1, 27, 22, 14, 93, 25, 15, 14, 0, 25, 13, 14, -1, 27, 22, 15, 62, 9, 29, 15, 0, 25, 13, 15, -1, 27, 22, 16, 45, 27, 18, 16, 13, 17, 17, 16, 0, 25, 16, 16, -1, 10, 22, 17, 0, 30, 16, 17, -1, 10, 22, 17, 10, 27, 16, 18, 45, 25, 18, 18, 62, 10, 29, 18, 13, 17, 17, 18, 0, 25, 16, 18, -1, 10, 22, 19, 0, 30, 29, 19, -1, 27, 22, 19, 10, 27, 29, 20, 45, 27, 16, 20, 62, 27, 29, 20, 91, 27, 4, 20, 0, 25, 21, 20, -1, 27, 22, 21, 62, 11, 29, 21, 0, 25, 21, 21, -1, 27, 22, 23, 62, 12, 29, 23, 0, 25, 1, 23, 32, 27, 36, 23, 13, 27, 36, 23, 10, 27, 36, 23, 9, 27, 36, 24, 0, 13, 24, 24, -1, 13, 22, 25, 61, 27, 3, 25, 62, 3, 29, 25, 0, 2, 1, 25, -1, 3, 22, 25, 32, 27, 25, 25, 13, 27, 25, 25, 10, 27, 25, 25, 9, 27, 25, 26, 62, 14, 29, 26, 0, 25, 26, 26, -1, 14, 22, 26, 32, 27, 26, 26, 13, 27, 26, 26, 10, 27, 26, 26, 9, 27, 26, 27, 47, 27, 23, 27, 62, 16, 29, 27, 0, 25, 27, 27, -1, 27, 22, 27, 32, 15, 36, 27, 13, 15, 36, 27, 10, 15, 36, 27, 9, 15, 36, 28, 0, 13, 28, 28, -1, 13, 22, 29, 38, 21, 24, 29, 60, 20, 35, 29, 13, 17, 19, 29, 0, 25, 29, 29, -1, 20, 22, 30, 62, 22, 29, 30, 13, 17, 31, 30, 0, 25, 30, 30, -1, 22, 22, 31, 0, 30, 30, 31, -1, 22, 22, 31, 10, 27, 30, 32, 62, 24, 29, 32, 0, 25, 32, 32, -1, 24, 22, 32, 32, 23, 30, 32, 13, 23, 30, 32, 10, 23, 30, 32, 9, 23, 30, 33, 34, 7, 36, 33, 38, 26, 24, 33, 0, 25, 33, 33, -1, 8, 22, 33, 32, 28, 33, 33, 13, 28, 33, 33, 10, 28, 33, 33, 9, 28, 33, 34, 62, 8, 29, 34, 0, 25, 34, 34, -1, 8, 22, 34, 32, 7, 36, 34, 13, 7, 36, 34, 10, 7, 36, 34, 9, 7, 36, 35, 33, 27, 20, 35, 47, 27, 26, 35, 63, 27, 32, 35, 0, 25, 27, 35, -1, 19, 22, 35, 32, 18, 29, 35, 13, 18, 29, 35, 10, 18, 29, 35, 9, 18, 29, 36, 47, 27, 23, 36, 62, 29, 29, 36, 0, 25, 1, 36, -1, 29, 22, 36, 32, 27, 36, 36, 13, 27, 36, 36, 10, 27, 36, 36, 9, 27, 36, 37, 0, 13, 37, 37, -1, 13, 22};
    private static final String[] debug_actionnames = new String[]{"", "A_ADUP", "A_ADUP_SAVE", "A_ADUP_STAGC", "A_ANAME", "A_ANAME_ADUP", "A_ANAME_ADUP_STAGC", "A_AVAL", "A_AVAL_STAGC", "A_CDATA", "A_CMNT", "A_DECL", "A_EMPTYTAG", "A_ENTITY", "A_ETAG", "A_GI", "A_GI_STAGC", "A_LF", "A_LT", "A_LT_PCDATA", "A_PCDATA", "A_PCDATA_SAVE_PUSH", "A_PI", "A_PITARGET", "A_PITARGET_PI", "A_SAVE", "A_SAVE_PUSH", "A_SKIP", "A_SP", "A_STAGC", "A_UNGET", "A_UNSAVE_PCDATA"};
    private static final String[] debug_statenames = new String[]{"", "S_ANAME", "S_APOS", "S_AVAL", "S_BB", "S_BBC", "S_BBCD", "S_BBCDA", "S_BBCDAT", "S_BBCDATA", "S_CCRLF", "S_CDATA", "S_CDATA2", "S_CDSECT", "S_CDSECT1", "S_CDSECT2", "S_COM", "S_COMCRLF", "S_COMD", "S_CRLF", "S_DECL", "S_DECL2", "S_DONE", "S_EMPTYTAG", "S_ENT", "S_EQ", "S_ETAG", "S_GI", "S_NCR", "S_PCDATA", "S_PI", "S_PICRLF", "S_PITARGET", "S_QUOT", "S_STAGC", "S_TAG", "S_TAGWS", "S_XNCR"};
    private String thePublicid;
    private String theSystemid;
    private int theLastLine;
    private int theLastColumn;
    private int theCurrentLine;
    private int theCurrentColumn;
    int theState;
    int theNextState;
    char[] theOutputBuffer = new char[200];
    int theSize;
    int[] theWinMap = new int[]{8364, 65533, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 65533, 381, 65533, 65533, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 65533, 382, 376};

    private void unread(PushbackReader r, int c) throws IOException {
        if (c != -1) {
            r.unread(c);
        }
    }

    public int getLineNumber() {
        return this.theLastLine;
    }

    public int getColumnNumber() {
        return this.theLastColumn;
    }

    public String getPublicId() {
        return this.thePublicid;
    }

    public String getSystemId() {
        return this.theSystemid;
    }

    public void resetDocumentLocator(String publicid, String systemid) {
        this.thePublicid = publicid;
        this.theSystemid = systemid;
        this.theCurrentColumn = 0;
        this.theCurrentLine = 0;
        this.theLastColumn = 0;
        this.theLastLine = 0;
    }

    public void scan(Reader r0, ScanHandler h) throws IOException, SAXException {
        this.theState = 29;
        int savedState = 0;
        int savedSize = 0;
        PushbackReader r = r0 instanceof PushbackReader ? (PushbackReader)r0 : (r0 instanceof BufferedReader ? new PushbackReader(r0) : new PushbackReader(new BufferedReader(r0)));
        while (this.theState != 22) {
            int ch = r.read();
            if (ch >= 128 && ch <= 159) {
                ch = this.theWinMap[ch - 128];
            }
            if (ch == 10) {
                ++this.theCurrentLine;
                this.theCurrentColumn = 0;
            } else {
                ++this.theCurrentColumn;
            }
            if (ch < 32 && ch != 10 && ch != 13 && ch != 9 && ch != -1) continue;
            int action = 0;
            for (int i = 0; i < statetable.length; i += 4) {
                if (this.theState != statetable[i]) {
                    if (action == 0) continue;
                    break;
                }
                if (statetable[i + 1] == 0) {
                    action = statetable[i + 2];
                    this.theNextState = statetable[i + 3];
                    continue;
                }
                if (statetable[i + 1] != ch) continue;
                action = statetable[i + 2];
                this.theNextState = statetable[i + 3];
                break;
            }
            switch (action) {
                case 0: {
                    throw new Error("HTMLScanner can't cope with " + Integer.toString(ch) + " in state " + Integer.toString(this.theState));
                }
                case 1: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 2: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    this.save(ch, h);
                    break;
                }
                case 3: {
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 4: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 5: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 6: {
                    h.aname(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.adup(this.theOutputBuffer, 0, this.theSize);
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 7: {
                    h.aval(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 8: {
                    h.aval(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 9: {
                    this.mark();
                    if (this.theSize > 1) {
                        this.theSize -= 2;
                    }
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 13: {
                    this.mark();
                    char ch1 = (char)ch;
                    if (this.theState == 24 && ch1 == '#') {
                        this.theNextState = 28;
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 28 && (ch1 == 'x' || ch1 == 'X')) {
                        this.theNextState = 37;
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 24 && Character.isLetterOrDigit(ch1)) {
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 28 && Character.isDigit(ch1)) {
                        this.save(ch, h);
                        break;
                    }
                    if (this.theState == 37 && (Character.isDigit(ch1) || "abcdefABCDEF".indexOf(ch1) != -1)) {
                        this.save(ch, h);
                        break;
                    }
                    h.entity(this.theOutputBuffer, savedSize + 1, this.theSize - savedSize - 1);
                    int ent = h.getEntity();
                    if (ent != 0) {
                        this.theSize = savedSize;
                        if (ent >= 128 && ent <= 159) {
                            ent = this.theWinMap[ent - 128];
                        }
                        if (ent < 32) {
                            ent = 32;
                        }
                        if (ent < 65536) {
                            this.save(ent, h);
                        } else {
                            this.save(((ent -= 65536) >> 10) + 55296, h);
                            this.save((ent & 0x3FF) + 56320, h);
                        }
                        if (ch != 59) {
                            this.unread(r, ch);
                            --this.theCurrentColumn;
                        }
                    } else {
                        this.unread(r, ch);
                        --this.theCurrentColumn;
                    }
                    this.theNextState = savedState;
                    break;
                }
                case 14: {
                    h.etag(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 11: {
                    h.decl(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 15: {
                    h.gi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 16: {
                    h.gi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 17: {
                    this.save(10, h);
                    break;
                }
                case 18: {
                    this.mark();
                    this.save(60, h);
                    break;
                }
                case 19: {
                    this.mark();
                    this.save(60, h);
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 20: {
                    this.mark();
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 10: {
                    this.mark();
                    if (this.theOutputBuffer[this.theSize - 1] == '-') {
                        --this.theSize;
                    }
                    if (this.theOutputBuffer[this.theSize - 1] == '-') {
                        --this.theSize;
                    }
                    h.cmnt(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 22: {
                    this.mark();
                    h.pi(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 23: {
                    h.pitarget(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 24: {
                    h.pitarget(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    h.pi(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 21: {
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                }
                case 26: {
                    savedState = this.theState;
                    savedSize = this.theSize;
                    this.save(ch, h);
                    break;
                }
                case 25: {
                    this.save(ch, h);
                    break;
                }
                case 27: {
                    break;
                }
                case 28: {
                    this.save(32, h);
                    break;
                }
                case 29: {
                    h.stagc(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                case 12: {
                    this.mark();
                    if (this.theSize > 0) {
                        h.gi(this.theOutputBuffer, 0, this.theSize);
                    }
                    this.theSize = 0;
                    h.stage(this.theOutputBuffer, 0, this.theSize);
                    break;
                }
                case 30: {
                    this.unread(r, ch);
                    --this.theCurrentColumn;
                    break;
                }
                case 31: {
                    if (this.theSize > 0) {
                        --this.theSize;
                    }
                    h.pcdata(this.theOutputBuffer, 0, this.theSize);
                    this.theSize = 0;
                    break;
                }
                default: {
                    throw new Error("Can't process state " + action);
                }
            }
            this.theState = this.theNextState;
        }
        h.eof(this.theOutputBuffer, 0, 0);
    }

    private void mark() {
        this.theLastColumn = this.theCurrentColumn;
        this.theLastLine = this.theCurrentLine;
    }

    public void startCDATA() {
        this.theNextState = 11;
    }

    private void save(int ch, ScanHandler h) throws IOException, SAXException {
        if (this.theSize >= this.theOutputBuffer.length - 20) {
            if (this.theState == 29 || this.theState == 11) {
                h.pcdata(this.theOutputBuffer, 0, this.theSize);
                this.theSize = 0;
            } else {
                char[] newOutputBuffer = new char[this.theOutputBuffer.length * 2];
                System.arraycopy(this.theOutputBuffer, 0, newOutputBuffer, 0, this.theSize + 1);
                this.theOutputBuffer = newOutputBuffer;
            }
        }
        this.theOutputBuffer[this.theSize++] = (char)ch;
    }

    public static void main(String[] argv) throws IOException, SAXException {
        HTMLScanner s = new HTMLScanner();
        InputStreamReader r = new InputStreamReader(System.in, "UTF-8");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        PYXWriter pw = new PYXWriter(w);
        s.scan(r, pw);
        ((Writer)w).close();
    }

    private static final String nicechar(int in) {
        if (in == 10) {
            return "\n";
        }
        if (in == 13) {
            return "\r";
        }
        if (in < 32) {
            return "0x" + Integer.toHexString(in);
        }
        return "'" + (char)in + "'";
    }
}

